<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for asyncResultModel StructType
 * @subpackage Structs
 */
class AsyncResultModel extends AbstractStructBase
{
    /**
     * The complete
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $complete;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The kind
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kind;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * The timeStamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeStamp;
    /**
     * The unitError
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnitErrorModel[]
     */
    public $unitError;
    /**
     * Constructor method for asyncResultModel
     * @uses AsyncResultModel::setComplete()
     * @uses AsyncResultModel::setCount()
     * @uses AsyncResultModel::setErrorCode()
     * @uses AsyncResultModel::setKind()
     * @uses AsyncResultModel::setMessage()
     * @uses AsyncResultModel::setRequestId()
     * @uses AsyncResultModel::setStartDate()
     * @uses AsyncResultModel::setStatus()
     * @uses AsyncResultModel::setTimeStamp()
     * @uses AsyncResultModel::setUnitError()
     * @param string[] $complete
     * @param int $count
     * @param string $errorCode
     * @param int $kind
     * @param string $message
     * @param int $requestId
     * @param string $startDate
     * @param int $status
     * @param string $timeStamp
     * @param \StructType\UnitErrorModel[] $unitError
     */
    public function __construct(array $complete = array(), $count = null, $errorCode = null, $kind = null, $message = null, $requestId = null, $startDate = null, $status = null, $timeStamp = null, array $unitError = array())
    {
        $this
            ->setComplete($complete)
            ->setCount($count)
            ->setErrorCode($errorCode)
            ->setKind($kind)
            ->setMessage($message)
            ->setRequestId($requestId)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setTimeStamp($timeStamp)
            ->setUnitError($unitError);
    }
    /**
     * Get complete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getComplete()
    {
        return isset($this->complete) ? $this->complete : null;
    }
    /**
     * Set complete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $complete
     * @return \StructType\AsyncResultModel
     */
    public function setComplete(array $complete = array())
    {
        foreach ($complete as $asyncResultModelCompleteItem) {
            // validation for constraint: itemType
            if (!is_string($asyncResultModelCompleteItem)) {
                throw new \InvalidArgumentException(sprintf('The complete property can only contain items of string, "%s" given', is_object($asyncResultModelCompleteItem) ? get_class($asyncResultModelCompleteItem) : gettype($asyncResultModelCompleteItem)), __LINE__);
            }
        }
        if (is_null($complete) || (is_array($complete) && empty($complete))) {
            unset($this->complete);
        } else {
            $this->complete = $complete;
        }
        return $this;
    }
    /**
     * Add item to complete value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AsyncResultModel
     */
    public function addToComplete($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The complete property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->complete[] = $item;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\AsyncResultModel
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\AsyncResultModel
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get kind value
     * @return int|null
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @param int $kind
     * @return \StructType\AsyncResultModel
     */
    public function setKind($kind = null)
    {
        // validation for constraint: int
        if (!is_null($kind) && !is_numeric($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kind)), __LINE__);
        }
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\AsyncResultModel
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\AsyncResultModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AsyncResultModel
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\AsyncResultModel
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \StructType\AsyncResultModel
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get unitError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnitErrorModel[]|null
     */
    public function getUnitError()
    {
        return isset($this->unitError) ? $this->unitError : null;
    }
    /**
     * Set unitError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnitErrorModel[] $unitError
     * @return \StructType\AsyncResultModel
     */
    public function setUnitError(array $unitError = array())
    {
        foreach ($unitError as $asyncResultModelUnitErrorItem) {
            // validation for constraint: itemType
            if (!$asyncResultModelUnitErrorItem instanceof \StructType\UnitErrorModel) {
                throw new \InvalidArgumentException(sprintf('The unitError property can only contain items of \StructType\UnitErrorModel, "%s" given', is_object($asyncResultModelUnitErrorItem) ? get_class($asyncResultModelUnitErrorItem) : gettype($asyncResultModelUnitErrorItem)), __LINE__);
            }
        }
        if (is_null($unitError) || (is_array($unitError) && empty($unitError))) {
            unset($this->unitError);
        } else {
            $this->unitError = $unitError;
        }
        return $this;
    }
    /**
     * Add item to unitError value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitErrorModel $item
     * @return \StructType\AsyncResultModel
     */
    public function addToUnitError(\StructType\UnitErrorModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitErrorModel) {
            throw new \InvalidArgumentException(sprintf('The unitError property can only contain items of \StructType\UnitErrorModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->unitError[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AsyncResultModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
