<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Decision ServiceType
 * @subpackage Services
 */
class Decision extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named decisionPoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DecisionPoint $parameters
     * @return \StructType\DecisionPointResponse|bool
     */
    public function decisionPoint(\StructType\DecisionPoint $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->decisionPoint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DecisionPointResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
