<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named changeEnclosureParent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeEnclosureParent $parameters
     * @return \StructType\ChangeEnclosureParentResponse|bool
     */
    public function changeEnclosureParent(\StructType\ChangeEnclosureParent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->changeEnclosureParent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named changeStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeStatus $parameters
     * @return \StructType\ChangeStatusResponse|bool
     */
    public function changeStatus(\StructType\ChangeStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->changeStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named changeRBankToUnprocessing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeRBankToUnprocessing $parameters
     * @return \StructType\ChangeRBankToUnprocessingResponse|bool
     */
    public function changeRBankToUnprocessing(\StructType\ChangeRBankToUnprocessing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->changeRBankToUnprocessing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChangeEnclosureParentResponse|\StructType\ChangeRBankToUnprocessingResponse|\StructType\ChangeStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
