<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateOrderRequestModel StructType
 * @subpackage Structs
 */
class UpdateOrderRequestModel extends BaseRequestModel
{
    /**
     * The orderModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderModel[]
     */
    public $orderModel;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for updateOrderRequestModel
     * @uses UpdateOrderRequestModel::setOrderModel()
     * @uses UpdateOrderRequestModel::setRequestId()
     * @param \StructType\OrderModel[] $orderModel
     * @param int $requestId
     */
    public function __construct(array $orderModel = array(), $requestId = null)
    {
        $this
            ->setOrderModel($orderModel)
            ->setRequestId($requestId);
    }
    /**
     * Get orderModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderModel[]|null
     */
    public function getOrderModel()
    {
        return isset($this->orderModel) ? $this->orderModel : null;
    }
    /**
     * Set orderModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderModel[] $orderModel
     * @return \StructType\UpdateOrderRequestModel
     */
    public function setOrderModel(array $orderModel = array())
    {
        foreach ($orderModel as $updateOrderRequestModelOrderModelItem) {
            // validation for constraint: itemType
            if (!$updateOrderRequestModelOrderModelItem instanceof \StructType\OrderModel) {
                throw new \InvalidArgumentException(sprintf('The orderModel property can only contain items of \StructType\OrderModel, "%s" given', is_object($updateOrderRequestModelOrderModelItem) ? get_class($updateOrderRequestModelOrderModelItem) : gettype($updateOrderRequestModelOrderModelItem)), __LINE__);
            }
        }
        if (is_null($orderModel) || (is_array($orderModel) && empty($orderModel))) {
            unset($this->orderModel);
        } else {
            $this->orderModel = $orderModel;
        }
        return $this;
    }
    /**
     * Add item to orderModel value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderModel $item
     * @return \StructType\UpdateOrderRequestModel
     */
    public function addToOrderModel(\StructType\OrderModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderModel) {
            throw new \InvalidArgumentException(sprintf('The orderModel property can only contain items of \StructType\OrderModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderModel[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\UpdateOrderRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateOrderRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
