<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unitErrorModel StructType
 * @subpackage Structs
 */
class UnitErrorModel extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The orderKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderKey;
    /**
     * Constructor method for unitErrorModel
     * @uses UnitErrorModel::setErrorCode()
     * @uses UnitErrorModel::setMessage()
     * @uses UnitErrorModel::setOrderKey()
     * @param string $errorCode
     * @param string $message
     * @param string $orderKey
     */
    public function __construct($errorCode = null, $message = null, $orderKey = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setMessage($message)
            ->setOrderKey($orderKey);
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\UnitErrorModel
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\UnitErrorModel
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get orderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->orderKey;
    }
    /**
     * Set orderKey value
     * @param string $orderKey
     * @return \StructType\UnitErrorModel
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->orderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitErrorModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
