<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageModel StructType
 * @subpackage Structs
 */
class PackageModel extends AbstractStructBase
{
    /**
     * The basketId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $basketId;
    /**
     * The deleteFlg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deleteFlg;
    /**
     * The deliveryCompanyId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryCompanyId;
    /**
     * The deliveryCvsModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeliveryCvsModel
     */
    public $deliveryCvsModel;
    /**
     * The deliveryPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $deliveryPrice;
    /**
     * The goodsPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $goodsPrice;
    /**
     * The goodsTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $goodsTax;
    /**
     * The itemModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemModel[]
     */
    public $itemModel;
    /**
     * The noshi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noshi;
    /**
     * The postagePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $postagePrice;
    /**
     * The senderModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonModel
     */
    public $senderModel;
    /**
     * The shippingNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingNumber;
    /**
     * Constructor method for packageModel
     * @uses PackageModel::setBasketId()
     * @uses PackageModel::setDeleteFlg()
     * @uses PackageModel::setDeliveryCompanyId()
     * @uses PackageModel::setDeliveryCvsModel()
     * @uses PackageModel::setDeliveryPrice()
     * @uses PackageModel::setGoodsPrice()
     * @uses PackageModel::setGoodsTax()
     * @uses PackageModel::setItemModel()
     * @uses PackageModel::setNoshi()
     * @uses PackageModel::setPostagePrice()
     * @uses PackageModel::setSenderModel()
     * @uses PackageModel::setShippingNumber()
     * @param int $basketId
     * @param bool $deleteFlg
     * @param string $deliveryCompanyId
     * @param \StructType\DeliveryCvsModel $deliveryCvsModel
     * @param int $deliveryPrice
     * @param int $goodsPrice
     * @param int $goodsTax
     * @param \StructType\ItemModel[] $itemModel
     * @param string $noshi
     * @param int $postagePrice
     * @param \StructType\PersonModel $senderModel
     * @param string $shippingNumber
     */
    public function __construct($basketId = null, $deleteFlg = null, $deliveryCompanyId = null, \StructType\DeliveryCvsModel $deliveryCvsModel = null, $deliveryPrice = null, $goodsPrice = null, $goodsTax = null, array $itemModel = array(), $noshi = null, $postagePrice = null, \StructType\PersonModel $senderModel = null, $shippingNumber = null)
    {
        $this
            ->setBasketId($basketId)
            ->setDeleteFlg($deleteFlg)
            ->setDeliveryCompanyId($deliveryCompanyId)
            ->setDeliveryCvsModel($deliveryCvsModel)
            ->setDeliveryPrice($deliveryPrice)
            ->setGoodsPrice($goodsPrice)
            ->setGoodsTax($goodsTax)
            ->setItemModel($itemModel)
            ->setNoshi($noshi)
            ->setPostagePrice($postagePrice)
            ->setSenderModel($senderModel)
            ->setShippingNumber($shippingNumber);
    }
    /**
     * Get basketId value
     * @return int|null
     */
    public function getBasketId()
    {
        return $this->basketId;
    }
    /**
     * Set basketId value
     * @param int $basketId
     * @return \StructType\PackageModel
     */
    public function setBasketId($basketId = null)
    {
        // validation for constraint: int
        if (!is_null($basketId) && !is_numeric($basketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($basketId)), __LINE__);
        }
        $this->basketId = $basketId;
        return $this;
    }
    /**
     * Get deleteFlg value
     * @return bool|null
     */
    public function getDeleteFlg()
    {
        return $this->deleteFlg;
    }
    /**
     * Set deleteFlg value
     * @param bool $deleteFlg
     * @return \StructType\PackageModel
     */
    public function setDeleteFlg($deleteFlg = null)
    {
        $this->deleteFlg = $deleteFlg;
        return $this;
    }
    /**
     * Get deliveryCompanyId value
     * @return string|null
     */
    public function getDeliveryCompanyId()
    {
        return $this->deliveryCompanyId;
    }
    /**
     * Set deliveryCompanyId value
     * @param string $deliveryCompanyId
     * @return \StructType\PackageModel
     */
    public function setDeliveryCompanyId($deliveryCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCompanyId) && !is_string($deliveryCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryCompanyId)), __LINE__);
        }
        $this->deliveryCompanyId = $deliveryCompanyId;
        return $this;
    }
    /**
     * Get deliveryCvsModel value
     * @return \StructType\DeliveryCvsModel|null
     */
    public function getDeliveryCvsModel()
    {
        return $this->deliveryCvsModel;
    }
    /**
     * Set deliveryCvsModel value
     * @param \StructType\DeliveryCvsModel $deliveryCvsModel
     * @return \StructType\PackageModel
     */
    public function setDeliveryCvsModel(\StructType\DeliveryCvsModel $deliveryCvsModel = null)
    {
        $this->deliveryCvsModel = $deliveryCvsModel;
        return $this;
    }
    /**
     * Get deliveryPrice value
     * @return int|null
     */
    public function getDeliveryPrice()
    {
        return $this->deliveryPrice;
    }
    /**
     * Set deliveryPrice value
     * @param int $deliveryPrice
     * @return \StructType\PackageModel
     */
    public function setDeliveryPrice($deliveryPrice = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPrice) && !is_numeric($deliveryPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryPrice)), __LINE__);
        }
        $this->deliveryPrice = $deliveryPrice;
        return $this;
    }
    /**
     * Get goodsPrice value
     * @return int|null
     */
    public function getGoodsPrice()
    {
        return $this->goodsPrice;
    }
    /**
     * Set goodsPrice value
     * @param int $goodsPrice
     * @return \StructType\PackageModel
     */
    public function setGoodsPrice($goodsPrice = null)
    {
        // validation for constraint: int
        if (!is_null($goodsPrice) && !is_numeric($goodsPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($goodsPrice)), __LINE__);
        }
        $this->goodsPrice = $goodsPrice;
        return $this;
    }
    /**
     * Get goodsTax value
     * @return int|null
     */
    public function getGoodsTax()
    {
        return $this->goodsTax;
    }
    /**
     * Set goodsTax value
     * @param int $goodsTax
     * @return \StructType\PackageModel
     */
    public function setGoodsTax($goodsTax = null)
    {
        // validation for constraint: int
        if (!is_null($goodsTax) && !is_numeric($goodsTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($goodsTax)), __LINE__);
        }
        $this->goodsTax = $goodsTax;
        return $this;
    }
    /**
     * Get itemModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemModel[]|null
     */
    public function getItemModel()
    {
        return isset($this->itemModel) ? $this->itemModel : null;
    }
    /**
     * Set itemModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemModel[] $itemModel
     * @return \StructType\PackageModel
     */
    public function setItemModel(array $itemModel = array())
    {
        foreach ($itemModel as $packageModelItemModelItem) {
            // validation for constraint: itemType
            if (!$packageModelItemModelItem instanceof \StructType\ItemModel) {
                throw new \InvalidArgumentException(sprintf('The itemModel property can only contain items of \StructType\ItemModel, "%s" given', is_object($packageModelItemModelItem) ? get_class($packageModelItemModelItem) : gettype($packageModelItemModelItem)), __LINE__);
            }
        }
        if (is_null($itemModel) || (is_array($itemModel) && empty($itemModel))) {
            unset($this->itemModel);
        } else {
            $this->itemModel = $itemModel;
        }
        return $this;
    }
    /**
     * Add item to itemModel value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemModel $item
     * @return \StructType\PackageModel
     */
    public function addToItemModel(\StructType\ItemModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemModel) {
            throw new \InvalidArgumentException(sprintf('The itemModel property can only contain items of \StructType\ItemModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->itemModel[] = $item;
        return $this;
    }
    /**
     * Get noshi value
     * @return string|null
     */
    public function getNoshi()
    {
        return $this->noshi;
    }
    /**
     * Set noshi value
     * @param string $noshi
     * @return \StructType\PackageModel
     */
    public function setNoshi($noshi = null)
    {
        // validation for constraint: string
        if (!is_null($noshi) && !is_string($noshi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noshi)), __LINE__);
        }
        $this->noshi = $noshi;
        return $this;
    }
    /**
     * Get postagePrice value
     * @return int|null
     */
    public function getPostagePrice()
    {
        return $this->postagePrice;
    }
    /**
     * Set postagePrice value
     * @param int $postagePrice
     * @return \StructType\PackageModel
     */
    public function setPostagePrice($postagePrice = null)
    {
        // validation for constraint: int
        if (!is_null($postagePrice) && !is_numeric($postagePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($postagePrice)), __LINE__);
        }
        $this->postagePrice = $postagePrice;
        return $this;
    }
    /**
     * Get senderModel value
     * @return \StructType\PersonModel|null
     */
    public function getSenderModel()
    {
        return $this->senderModel;
    }
    /**
     * Set senderModel value
     * @param \StructType\PersonModel $senderModel
     * @return \StructType\PackageModel
     */
    public function setSenderModel(\StructType\PersonModel $senderModel = null)
    {
        $this->senderModel = $senderModel;
        return $this;
    }
    /**
     * Get shippingNumber value
     * @return string|null
     */
    public function getShippingNumber()
    {
        return $this->shippingNumber;
    }
    /**
     * Set shippingNumber value
     * @param string $shippingNumber
     * @return \StructType\PackageModel
     */
    public function setShippingNumber($shippingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shippingNumber) && !is_string($shippingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingNumber)), __LINE__);
        }
        $this->shippingNumber = $shippingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
