<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for normalOrderModel StructType
 * @subpackage Structs
 */
class NormalOrderModel extends AbstractStructBase
{
    /**
     * The detailId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $detailId;
    /**
     * The reserveDatetime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reserveDatetime;
    /**
     * The reserveNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reserveNumber;
    /**
     * The reserveType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reserveType;
    /**
     * Constructor method for normalOrderModel
     * @uses NormalOrderModel::setDetailId()
     * @uses NormalOrderModel::setReserveDatetime()
     * @uses NormalOrderModel::setReserveNumber()
     * @uses NormalOrderModel::setReserveType()
     * @param int $detailId
     * @param string $reserveDatetime
     * @param string $reserveNumber
     * @param int $reserveType
     */
    public function __construct($detailId = null, $reserveDatetime = null, $reserveNumber = null, $reserveType = null)
    {
        $this
            ->setDetailId($detailId)
            ->setReserveDatetime($reserveDatetime)
            ->setReserveNumber($reserveNumber)
            ->setReserveType($reserveType);
    }
    /**
     * Get detailId value
     * @return int|null
     */
    public function getDetailId()
    {
        return $this->detailId;
    }
    /**
     * Set detailId value
     * @param int $detailId
     * @return \StructType\NormalOrderModel
     */
    public function setDetailId($detailId = null)
    {
        // validation for constraint: int
        if (!is_null($detailId) && !is_numeric($detailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($detailId)), __LINE__);
        }
        $this->detailId = $detailId;
        return $this;
    }
    /**
     * Get reserveDatetime value
     * @return string|null
     */
    public function getReserveDatetime()
    {
        return $this->reserveDatetime;
    }
    /**
     * Set reserveDatetime value
     * @param string $reserveDatetime
     * @return \StructType\NormalOrderModel
     */
    public function setReserveDatetime($reserveDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($reserveDatetime) && !is_string($reserveDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reserveDatetime)), __LINE__);
        }
        $this->reserveDatetime = $reserveDatetime;
        return $this;
    }
    /**
     * Get reserveNumber value
     * @return string|null
     */
    public function getReserveNumber()
    {
        return $this->reserveNumber;
    }
    /**
     * Set reserveNumber value
     * @param string $reserveNumber
     * @return \StructType\NormalOrderModel
     */
    public function setReserveNumber($reserveNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reserveNumber) && !is_string($reserveNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reserveNumber)), __LINE__);
        }
        $this->reserveNumber = $reserveNumber;
        return $this;
    }
    /**
     * Get reserveType value
     * @return int|null
     */
    public function getReserveType()
    {
        return $this->reserveType;
    }
    /**
     * Set reserveType value
     * @param int $reserveType
     * @return \StructType\NormalOrderModel
     */
    public function setReserveType($reserveType = null)
    {
        // validation for constraint: int
        if (!is_null($reserveType) && !is_numeric($reserveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reserveType)), __LINE__);
        }
        $this->reserveType = $reserveType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NormalOrderModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
