<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEnclosureListRequestModel StructType
 * @subpackage Structs
 */
class GetEnclosureListRequestModel extends BaseRequestModel
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for getEnclosureListRequestModel
     * @uses GetEnclosureListRequestModel::setOrderNumber()
     * @uses GetEnclosureListRequestModel::setRequestId()
     * @param string $orderNumber
     * @param int $requestId
     */
    public function __construct($orderNumber = null, $requestId = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setRequestId($requestId);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\GetEnclosureListRequestModel
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\GetEnclosureListRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEnclosureListRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
