<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for enclosureGroupModel StructType
 * @subpackage Structs
 */
class EnclosureGroupModel extends AbstractStructBase
{
    /**
     * The enclosureModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrderModel
     */
    public $enclosureModel;
    /**
     * The nominateOrderModelList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderModel[]
     */
    public $nominateOrderModelList;
    /**
     * Constructor method for enclosureGroupModel
     * @uses EnclosureGroupModel::setEnclosureModel()
     * @uses EnclosureGroupModel::setNominateOrderModelList()
     * @param \StructType\OrderModel $enclosureModel
     * @param \StructType\OrderModel[] $nominateOrderModelList
     */
    public function __construct(\StructType\OrderModel $enclosureModel = null, array $nominateOrderModelList = array())
    {
        $this
            ->setEnclosureModel($enclosureModel)
            ->setNominateOrderModelList($nominateOrderModelList);
    }
    /**
     * Get enclosureModel value
     * @return \StructType\OrderModel|null
     */
    public function getEnclosureModel()
    {
        return $this->enclosureModel;
    }
    /**
     * Set enclosureModel value
     * @param \StructType\OrderModel $enclosureModel
     * @return \StructType\EnclosureGroupModel
     */
    public function setEnclosureModel(\StructType\OrderModel $enclosureModel = null)
    {
        $this->enclosureModel = $enclosureModel;
        return $this;
    }
    /**
     * Get nominateOrderModelList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderModel[]|null
     */
    public function getNominateOrderModelList()
    {
        return isset($this->nominateOrderModelList) ? $this->nominateOrderModelList : null;
    }
    /**
     * Set nominateOrderModelList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderModel[] $nominateOrderModelList
     * @return \StructType\EnclosureGroupModel
     */
    public function setNominateOrderModelList(array $nominateOrderModelList = array())
    {
        foreach ($nominateOrderModelList as $enclosureGroupModelNominateOrderModelListItem) {
            // validation for constraint: itemType
            if (!$enclosureGroupModelNominateOrderModelListItem instanceof \StructType\OrderModel) {
                throw new \InvalidArgumentException(sprintf('The nominateOrderModelList property can only contain items of \StructType\OrderModel, "%s" given', is_object($enclosureGroupModelNominateOrderModelListItem) ? get_class($enclosureGroupModelNominateOrderModelListItem) : gettype($enclosureGroupModelNominateOrderModelListItem)), __LINE__);
            }
        }
        if (is_null($nominateOrderModelList) || (is_array($nominateOrderModelList) && empty($nominateOrderModelList))) {
            unset($this->nominateOrderModelList);
        } else {
            $this->nominateOrderModelList = $nominateOrderModelList;
        }
        return $this;
    }
    /**
     * Add item to nominateOrderModelList value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderModel $item
     * @return \StructType\EnclosureGroupModel
     */
    public function addToNominateOrderModelList(\StructType\OrderModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderModel) {
            throw new \InvalidArgumentException(sprintf('The nominateOrderModelList property can only contain items of \StructType\OrderModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->nominateOrderModelList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnclosureGroupModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
