<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.rms.rakuten.co.jp/es/1.0/order/ws?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.rms.rakuten.co.jp/es/1.0/order/ws?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getRequestId operation/method
 */
if ($get->getRequestId(new \StructType\GetRequestId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for _getResult operation/method
 */
if ($get->_getResult(new \StructType\GetResult()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrder operation/method
 */
if ($get->getOrder(new \StructType\GetOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEnclosureList operation/method
 */
if ($get->getEnclosureList(new \StructType\GetEnclosureList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateOrder operation/method
 */
if ($update->updateOrder(new \StructType\UpdateOrder()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelOrder operation/method
 */
if ($cancel->cancelOrder(new \StructType\CancelOrder()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
/**
 * Sample call for doEnclosure operation/method
 */
if ($do->doEnclosure(new \StructType\DoEnclosure()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doUnEnclosure operation/method
 */
if ($do->doUnEnclosure(new \StructType\DoUnEnclosure()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeEnclosureParent operation/method
 */
if ($change->changeEnclosureParent(new \StructType\ChangeEnclosureParent()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeStatus operation/method
 */
if ($change->changeStatus(new \StructType\ChangeStatus()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeRBankToUnprocessing operation/method
 */
if ($change->changeRBankToUnprocessing(new \StructType\ChangeRBankToUnprocessing()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Decision ServiceType
 */
$decision = new \ServiceType\Decision($options);
/**
 * Sample call for decisionPoint operation/method
 */
if ($decision->decisionPoint(new \StructType\DecisionPoint()) !== false) {
    print_r($decision->getResult());
} else {
    print_r($decision->getLastError());
}
/**
 * Samples for RB ServiceType
 */
$rB = new \ServiceType\RB($options);
/**
 * Sample call for rBankAccountTransfer operation/method
 */
if ($rB->rBankAccountTransfer(new \StructType\RBankAccountTransfer()) !== false) {
    print_r($rB->getResult());
} else {
    print_r($rB->getLastError());
}
