<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gbuyItemModel StructType
 * @subpackage Structs
 */
class GbuyItemModel extends AbstractStructBase
{
    /**
     * The currentSumAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currentSumAmount;
    /**
     * The gbuyBidInventoryModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GbuyBidInventoryModel[]
     */
    public $gbuyBidInventoryModel;
    /**
     * The gbuyGchoiceModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GbuyGchoiceModel[]
     */
    public $gbuyGchoiceModel;
    /**
     * The isShiftStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isShiftStatus;
    /**
     * The shiftDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shiftDate;
    /**
     * The unitText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitText;
    /**
     * Constructor method for gbuyItemModel
     * @uses GbuyItemModel::setCurrentSumAmount()
     * @uses GbuyItemModel::setGbuyBidInventoryModel()
     * @uses GbuyItemModel::setGbuyGchoiceModel()
     * @uses GbuyItemModel::setIsShiftStatus()
     * @uses GbuyItemModel::setShiftDate()
     * @uses GbuyItemModel::setUnitText()
     * @param int $currentSumAmount
     * @param \StructType\GbuyBidInventoryModel[] $gbuyBidInventoryModel
     * @param \StructType\GbuyGchoiceModel[] $gbuyGchoiceModel
     * @param bool $isShiftStatus
     * @param string $shiftDate
     * @param string $unitText
     */
    public function __construct($currentSumAmount = null, array $gbuyBidInventoryModel = array(), array $gbuyGchoiceModel = array(), $isShiftStatus = null, $shiftDate = null, $unitText = null)
    {
        $this
            ->setCurrentSumAmount($currentSumAmount)
            ->setGbuyBidInventoryModel($gbuyBidInventoryModel)
            ->setGbuyGchoiceModel($gbuyGchoiceModel)
            ->setIsShiftStatus($isShiftStatus)
            ->setShiftDate($shiftDate)
            ->setUnitText($unitText);
    }
    /**
     * Get currentSumAmount value
     * @return int|null
     */
    public function getCurrentSumAmount()
    {
        return $this->currentSumAmount;
    }
    /**
     * Set currentSumAmount value
     * @param int $currentSumAmount
     * @return \StructType\GbuyItemModel
     */
    public function setCurrentSumAmount($currentSumAmount = null)
    {
        // validation for constraint: int
        if (!is_null($currentSumAmount) && !is_numeric($currentSumAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentSumAmount)), __LINE__);
        }
        $this->currentSumAmount = $currentSumAmount;
        return $this;
    }
    /**
     * Get gbuyBidInventoryModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GbuyBidInventoryModel[]|null
     */
    public function getGbuyBidInventoryModel()
    {
        return isset($this->gbuyBidInventoryModel) ? $this->gbuyBidInventoryModel : null;
    }
    /**
     * Set gbuyBidInventoryModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GbuyBidInventoryModel[] $gbuyBidInventoryModel
     * @return \StructType\GbuyItemModel
     */
    public function setGbuyBidInventoryModel(array $gbuyBidInventoryModel = array())
    {
        foreach ($gbuyBidInventoryModel as $gbuyItemModelGbuyBidInventoryModelItem) {
            // validation for constraint: itemType
            if (!$gbuyItemModelGbuyBidInventoryModelItem instanceof \StructType\GbuyBidInventoryModel) {
                throw new \InvalidArgumentException(sprintf('The gbuyBidInventoryModel property can only contain items of \StructType\GbuyBidInventoryModel, "%s" given', is_object($gbuyItemModelGbuyBidInventoryModelItem) ? get_class($gbuyItemModelGbuyBidInventoryModelItem) : gettype($gbuyItemModelGbuyBidInventoryModelItem)), __LINE__);
            }
        }
        if (is_null($gbuyBidInventoryModel) || (is_array($gbuyBidInventoryModel) && empty($gbuyBidInventoryModel))) {
            unset($this->gbuyBidInventoryModel);
        } else {
            $this->gbuyBidInventoryModel = $gbuyBidInventoryModel;
        }
        return $this;
    }
    /**
     * Add item to gbuyBidInventoryModel value
     * @throws \InvalidArgumentException
     * @param \StructType\GbuyBidInventoryModel $item
     * @return \StructType\GbuyItemModel
     */
    public function addToGbuyBidInventoryModel(\StructType\GbuyBidInventoryModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GbuyBidInventoryModel) {
            throw new \InvalidArgumentException(sprintf('The gbuyBidInventoryModel property can only contain items of \StructType\GbuyBidInventoryModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->gbuyBidInventoryModel[] = $item;
        return $this;
    }
    /**
     * Get gbuyGchoiceModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GbuyGchoiceModel[]|null
     */
    public function getGbuyGchoiceModel()
    {
        return isset($this->gbuyGchoiceModel) ? $this->gbuyGchoiceModel : null;
    }
    /**
     * Set gbuyGchoiceModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GbuyGchoiceModel[] $gbuyGchoiceModel
     * @return \StructType\GbuyItemModel
     */
    public function setGbuyGchoiceModel(array $gbuyGchoiceModel = array())
    {
        foreach ($gbuyGchoiceModel as $gbuyItemModelGbuyGchoiceModelItem) {
            // validation for constraint: itemType
            if (!$gbuyItemModelGbuyGchoiceModelItem instanceof \StructType\GbuyGchoiceModel) {
                throw new \InvalidArgumentException(sprintf('The gbuyGchoiceModel property can only contain items of \StructType\GbuyGchoiceModel, "%s" given', is_object($gbuyItemModelGbuyGchoiceModelItem) ? get_class($gbuyItemModelGbuyGchoiceModelItem) : gettype($gbuyItemModelGbuyGchoiceModelItem)), __LINE__);
            }
        }
        if (is_null($gbuyGchoiceModel) || (is_array($gbuyGchoiceModel) && empty($gbuyGchoiceModel))) {
            unset($this->gbuyGchoiceModel);
        } else {
            $this->gbuyGchoiceModel = $gbuyGchoiceModel;
        }
        return $this;
    }
    /**
     * Add item to gbuyGchoiceModel value
     * @throws \InvalidArgumentException
     * @param \StructType\GbuyGchoiceModel $item
     * @return \StructType\GbuyItemModel
     */
    public function addToGbuyGchoiceModel(\StructType\GbuyGchoiceModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GbuyGchoiceModel) {
            throw new \InvalidArgumentException(sprintf('The gbuyGchoiceModel property can only contain items of \StructType\GbuyGchoiceModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->gbuyGchoiceModel[] = $item;
        return $this;
    }
    /**
     * Get isShiftStatus value
     * @return bool|null
     */
    public function getIsShiftStatus()
    {
        return $this->isShiftStatus;
    }
    /**
     * Set isShiftStatus value
     * @param bool $isShiftStatus
     * @return \StructType\GbuyItemModel
     */
    public function setIsShiftStatus($isShiftStatus = null)
    {
        $this->isShiftStatus = $isShiftStatus;
        return $this;
    }
    /**
     * Get shiftDate value
     * @return string|null
     */
    public function getShiftDate()
    {
        return $this->shiftDate;
    }
    /**
     * Set shiftDate value
     * @param string $shiftDate
     * @return \StructType\GbuyItemModel
     */
    public function setShiftDate($shiftDate = null)
    {
        // validation for constraint: string
        if (!is_null($shiftDate) && !is_string($shiftDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shiftDate)), __LINE__);
        }
        $this->shiftDate = $shiftDate;
        return $this;
    }
    /**
     * Get unitText value
     * @return string|null
     */
    public function getUnitText()
    {
        return $this->unitText;
    }
    /**
     * Set unitText value
     * @param string $unitText
     * @return \StructType\GbuyItemModel
     */
    public function setUnitText($unitText = null)
    {
        // validation for constraint: string
        if (!is_null($unitText) && !is_string($unitText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitText)), __LINE__);
        }
        $this->unitText = $unitText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GbuyItemModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
