<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for doUnEnclosureRequestModel StructType
 * @subpackage Structs
 */
class DoUnEnclosureRequestModel extends BaseRequestModel
{
    /**
     * The nominateUnEnclosureModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NominateUnEnclosureModel[]
     */
    public $nominateUnEnclosureModel;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for doUnEnclosureRequestModel
     * @uses DoUnEnclosureRequestModel::setNominateUnEnclosureModel()
     * @uses DoUnEnclosureRequestModel::setRequestId()
     * @param \StructType\NominateUnEnclosureModel[] $nominateUnEnclosureModel
     * @param int $requestId
     */
    public function __construct(array $nominateUnEnclosureModel = array(), $requestId = null)
    {
        $this
            ->setNominateUnEnclosureModel($nominateUnEnclosureModel)
            ->setRequestId($requestId);
    }
    /**
     * Get nominateUnEnclosureModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NominateUnEnclosureModel[]|null
     */
    public function getNominateUnEnclosureModel()
    {
        return isset($this->nominateUnEnclosureModel) ? $this->nominateUnEnclosureModel : null;
    }
    /**
     * Set nominateUnEnclosureModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NominateUnEnclosureModel[] $nominateUnEnclosureModel
     * @return \StructType\DoUnEnclosureRequestModel
     */
    public function setNominateUnEnclosureModel(array $nominateUnEnclosureModel = array())
    {
        foreach ($nominateUnEnclosureModel as $doUnEnclosureRequestModelNominateUnEnclosureModelItem) {
            // validation for constraint: itemType
            if (!$doUnEnclosureRequestModelNominateUnEnclosureModelItem instanceof \StructType\NominateUnEnclosureModel) {
                throw new \InvalidArgumentException(sprintf('The nominateUnEnclosureModel property can only contain items of \StructType\NominateUnEnclosureModel, "%s" given', is_object($doUnEnclosureRequestModelNominateUnEnclosureModelItem) ? get_class($doUnEnclosureRequestModelNominateUnEnclosureModelItem) : gettype($doUnEnclosureRequestModelNominateUnEnclosureModelItem)), __LINE__);
            }
        }
        if (is_null($nominateUnEnclosureModel) || (is_array($nominateUnEnclosureModel) && empty($nominateUnEnclosureModel))) {
            unset($this->nominateUnEnclosureModel);
        } else {
            $this->nominateUnEnclosureModel = $nominateUnEnclosureModel;
        }
        return $this;
    }
    /**
     * Add item to nominateUnEnclosureModel value
     * @throws \InvalidArgumentException
     * @param \StructType\NominateUnEnclosureModel $item
     * @return \StructType\DoUnEnclosureRequestModel
     */
    public function addToNominateUnEnclosureModel(\StructType\NominateUnEnclosureModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NominateUnEnclosureModel) {
            throw new \InvalidArgumentException(sprintf('The nominateUnEnclosureModel property can only contain items of \StructType\NominateUnEnclosureModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->nominateUnEnclosureModel[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\DoUnEnclosureRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoUnEnclosureRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
