<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for baseResponseModel StructType
 * @subpackage Structs
 */
class BaseResponseModel extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The unitError
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnitErrorModel[]
     */
    public $unitError;
    /**
     * Constructor method for baseResponseModel
     * @uses BaseResponseModel::setErrorCode()
     * @uses BaseResponseModel::setMessage()
     * @uses BaseResponseModel::setUnitError()
     * @param string $errorCode
     * @param string $message
     * @param \StructType\UnitErrorModel[] $unitError
     */
    public function __construct($errorCode = null, $message = null, array $unitError = array())
    {
        $this
            ->setErrorCode($errorCode)
            ->setMessage($message)
            ->setUnitError($unitError);
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\BaseResponseModel
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\BaseResponseModel
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get unitError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnitErrorModel[]|null
     */
    public function getUnitError()
    {
        return isset($this->unitError) ? $this->unitError : null;
    }
    /**
     * Set unitError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnitErrorModel[] $unitError
     * @return \StructType\BaseResponseModel
     */
    public function setUnitError(array $unitError = array())
    {
        foreach ($unitError as $baseResponseModelUnitErrorItem) {
            // validation for constraint: itemType
            if (!$baseResponseModelUnitErrorItem instanceof \StructType\UnitErrorModel) {
                throw new \InvalidArgumentException(sprintf('The unitError property can only contain items of \StructType\UnitErrorModel, "%s" given', is_object($baseResponseModelUnitErrorItem) ? get_class($baseResponseModelUnitErrorItem) : gettype($baseResponseModelUnitErrorItem)), __LINE__);
            }
        }
        if (is_null($unitError) || (is_array($unitError) && empty($unitError))) {
            unset($this->unitError);
        } else {
            $this->unitError = $unitError;
        }
        return $this;
    }
    /**
     * Add item to unitError value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitErrorModel $item
     * @return \StructType\BaseResponseModel
     */
    public function addToUnitError(\StructType\UnitErrorModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitErrorModel) {
            throw new \InvalidArgumentException(sprintf('The unitError property can only contain items of \StructType\UnitErrorModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->unitError[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseResponseModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
