<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for RB ServiceType
 * @subpackage Services
 */
class RB extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rBankAccountTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RBankAccountTransfer $parameters
     * @return \StructType\RBankAccountTransferResponse|bool
     */
    public function rBankAccountTransfer(\StructType\RBankAccountTransfer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->rBankAccountTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RBankAccountTransferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
