<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nominateEnclosureModel StructType
 * @subpackage Structs
 */
class NominateEnclosureModel extends AbstractStructBase
{
    /**
     * The childOrderNumberList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $childOrderNumberList;
    /**
     * The parentOrderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parentOrderNumber;
    /**
     * Constructor method for nominateEnclosureModel
     * @uses NominateEnclosureModel::setChildOrderNumberList()
     * @uses NominateEnclosureModel::setParentOrderNumber()
     * @param string[] $childOrderNumberList
     * @param string $parentOrderNumber
     */
    public function __construct(array $childOrderNumberList = array(), $parentOrderNumber = null)
    {
        $this
            ->setChildOrderNumberList($childOrderNumberList)
            ->setParentOrderNumber($parentOrderNumber);
    }
    /**
     * Get childOrderNumberList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getChildOrderNumberList()
    {
        return isset($this->childOrderNumberList) ? $this->childOrderNumberList : null;
    }
    /**
     * Set childOrderNumberList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $childOrderNumberList
     * @return \StructType\NominateEnclosureModel
     */
    public function setChildOrderNumberList(array $childOrderNumberList = array())
    {
        foreach ($childOrderNumberList as $nominateEnclosureModelChildOrderNumberListItem) {
            // validation for constraint: itemType
            if (!is_string($nominateEnclosureModelChildOrderNumberListItem)) {
                throw new \InvalidArgumentException(sprintf('The childOrderNumberList property can only contain items of string, "%s" given', is_object($nominateEnclosureModelChildOrderNumberListItem) ? get_class($nominateEnclosureModelChildOrderNumberListItem) : gettype($nominateEnclosureModelChildOrderNumberListItem)), __LINE__);
            }
        }
        if (is_null($childOrderNumberList) || (is_array($childOrderNumberList) && empty($childOrderNumberList))) {
            unset($this->childOrderNumberList);
        } else {
            $this->childOrderNumberList = $childOrderNumberList;
        }
        return $this;
    }
    /**
     * Add item to childOrderNumberList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NominateEnclosureModel
     */
    public function addToChildOrderNumberList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The childOrderNumberList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->childOrderNumberList[] = $item;
        return $this;
    }
    /**
     * Get parentOrderNumber value
     * @return string|null
     */
    public function getParentOrderNumber()
    {
        return $this->parentOrderNumber;
    }
    /**
     * Set parentOrderNumber value
     * @param string $parentOrderNumber
     * @return \StructType\NominateEnclosureModel
     */
    public function setParentOrderNumber($parentOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parentOrderNumber) && !is_string($parentOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentOrderNumber)), __LINE__);
        }
        $this->parentOrderNumber = $parentOrderNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NominateEnclosureModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
