<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getResultRequestModel StructType
 * @subpackage Structs
 */
class GetResultRequestModel extends BaseRequestModel
{
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $requestId;
    /**
     * Constructor method for getResultRequestModel
     * @uses GetResultRequestModel::setRequestId()
     * @param int[] $requestId
     */
    public function __construct(array $requestId = array())
    {
        $this
            ->setRequestId($requestId);
    }
    /**
     * Get requestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getRequestId()
    {
        return isset($this->requestId) ? $this->requestId : null;
    }
    /**
     * Set requestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $requestId
     * @return \StructType\GetResultRequestModel
     */
    public function setRequestId(array $requestId = array())
    {
        foreach ($requestId as $getResultRequestModelRequestIdItem) {
            // validation for constraint: itemType
            if (!is_numeric($getResultRequestModelRequestIdItem)) {
                throw new \InvalidArgumentException(sprintf('The requestId property can only contain items of int, "%s" given', is_object($getResultRequestModelRequestIdItem) ? get_class($getResultRequestModelRequestIdItem) : gettype($getResultRequestModelRequestIdItem)), __LINE__);
            }
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->requestId);
        } else {
            $this->requestId = $requestId;
        }
        return $this;
    }
    /**
     * Add item to requestId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\GetResultRequestModel
     */
    public function addToRequestId($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The requestId property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->requestId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetResultRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
