<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for changeRBankToUnprocessingRequestModel StructType
 * @subpackage Structs
 */
class ChangeRBankToUnprocessingRequestModel extends BaseRequestModel
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $orderNumber;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for changeRBankToUnprocessingRequestModel
     * @uses ChangeRBankToUnprocessingRequestModel::setOrderNumber()
     * @uses ChangeRBankToUnprocessingRequestModel::setRequestId()
     * @param string[] $orderNumber
     * @param int $requestId
     */
    public function __construct(array $orderNumber = array(), $requestId = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setRequestId($requestId);
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $orderNumber
     * @return \StructType\ChangeRBankToUnprocessingRequestModel
     */
    public function setOrderNumber(array $orderNumber = array())
    {
        foreach ($orderNumber as $changeRBankToUnprocessingRequestModelOrderNumberItem) {
            // validation for constraint: itemType
            if (!is_string($changeRBankToUnprocessingRequestModelOrderNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($changeRBankToUnprocessingRequestModelOrderNumberItem) ? get_class($changeRBankToUnprocessingRequestModelOrderNumberItem) : gettype($changeRBankToUnprocessingRequestModelOrderNumberItem)), __LINE__);
            }
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Add item to orderNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChangeRBankToUnprocessingRequestModel
     */
    public function addToOrderNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderNumber[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\ChangeRBankToUnprocessingRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeRBankToUnprocessingRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
