<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelModel StructType
 * @subpackage Structs
 */
class CancelModel extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The reasonId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reasonId;
    /**
     * The restoreInventoryFlag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $restoreInventoryFlag;
    /**
     * Constructor method for cancelModel
     * @uses CancelModel::setOrderNumber()
     * @uses CancelModel::setReasonId()
     * @uses CancelModel::setRestoreInventoryFlag()
     * @param string $orderNumber
     * @param int $reasonId
     * @param int $restoreInventoryFlag
     */
    public function __construct($orderNumber = null, $reasonId = null, $restoreInventoryFlag = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setReasonId($reasonId)
            ->setRestoreInventoryFlag($restoreInventoryFlag);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\CancelModel
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get reasonId value
     * @return int|null
     */
    public function getReasonId()
    {
        return $this->reasonId;
    }
    /**
     * Set reasonId value
     * @param int $reasonId
     * @return \StructType\CancelModel
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: int
        if (!is_null($reasonId) && !is_numeric($reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reasonId)), __LINE__);
        }
        $this->reasonId = $reasonId;
        return $this;
    }
    /**
     * Get restoreInventoryFlag value
     * @return int|null
     */
    public function getRestoreInventoryFlag()
    {
        return $this->restoreInventoryFlag;
    }
    /**
     * Set restoreInventoryFlag value
     * @param int $restoreInventoryFlag
     * @return \StructType\CancelModel
     */
    public function setRestoreInventoryFlag($restoreInventoryFlag = null)
    {
        // validation for constraint: int
        if (!is_null($restoreInventoryFlag) && !is_numeric($restoreInventoryFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($restoreInventoryFlag)), __LINE__);
        }
        $this->restoreInventoryFlag = $restoreInventoryFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
