<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintType StructType
 * @subpackage Structs
 */
class PrintType extends AbstractStructBase
{
    /**
     * The kind
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kind;
    /**
     * The method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $method;
    /**
     * Constructor method for PrintType
     * @uses PrintType::setKind()
     * @uses PrintType::setMethod()
     * @param string $kind
     * @param string $method
     */
    public function __construct($kind = null, $method = null)
    {
        $this
            ->setKind($kind)
            ->setMethod($method);
    }
    /**
     * Get kind value
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Set kind value
     * @uses \EnumType\PrintKindEnum::valueIsValid()
     * @uses \EnumType\PrintKindEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \StructType\PrintType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintKindEnum::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintKindEnum', is_array($kind) ? implode(', ', $kind) : var_export($kind, true), implode(', ', \EnumType\PrintKindEnum::getValidValues())), __LINE__);
        }
        $this->kind = $kind;
        return $this;
    }
    /**
     * Get method value
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @uses \EnumType\PrintMethodEnum::valueIsValid()
     * @uses \EnumType\PrintMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return \StructType\PrintType
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintMethodEnum::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintMethodEnum', is_array($method) ? implode(', ', $method) : var_export($method, true), implode(', ', \EnumType\PrintMethodEnum::getValidValues())), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
