<?php

namespace EnumType;

/**
 * This class stands for zasadySpecjalneEnum EnumType
 * @subpackage Enumerations
 */
class ZasadySpecjalneEnum
{
    /**
     * Constant for value 'ADMINISTRACYJNA'
     * @return string 'ADMINISTRACYJNA'
     */
    const VALUE_ADMINISTRACYJNA = 'ADMINISTRACYJNA';
    /**
     * Constant for value 'PODATKOWA'
     * @return string 'PODATKOWA'
     */
    const VALUE_PODATKOWA = 'PODATKOWA';
    /**
     * Constant for value 'SADOWA_CYWILNA'
     * @return string 'SADOWA_CYWILNA'
     */
    const VALUE_SADOWA_CYWILNA = 'SADOWA_CYWILNA';
    /**
     * Constant for value 'SADOWA_KARNA'
     * @return string 'SADOWA_KARNA'
     */
    const VALUE_SADOWA_KARNA = 'SADOWA_KARNA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADMINISTRACYJNA
     * @uses self::VALUE_PODATKOWA
     * @uses self::VALUE_SADOWA_CYWILNA
     * @uses self::VALUE_SADOWA_KARNA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADMINISTRACYJNA,
            self::VALUE_PODATKOWA,
            self::VALUE_SADOWA_CYWILNA,
            self::VALUE_SADOWA_KARNA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
