<?php

namespace EnumType;

/**
 * This class stands for rozstrzygniecieType EnumType
 * @subpackage Enumerations
 */
class RozstrzygniecieType
{
    /**
     * Constant for value 'UZASADNIONA'
     * @return string 'UZASADNIONA'
     */
    const VALUE_UZASADNIONA = 'UZASADNIONA';
    /**
     * Constant for value 'NIEUZASADNIONA'
     * @return string 'NIEUZASADNIONA'
     */
    const VALUE_NIEUZASADNIONA = 'NIEUZASADNIONA';
    /**
     * Constant for value 'NIEWNIESIONA'
     * @return string 'NIEWNIESIONA'
     */
    const VALUE_NIEWNIESIONA = 'NIEWNIESIONA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UZASADNIONA
     * @uses self::VALUE_NIEUZASADNIONA
     * @uses self::VALUE_NIEWNIESIONA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UZASADNIONA,
            self::VALUE_NIEUZASADNIONA,
            self::VALUE_NIEWNIESIONA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
