<?php

namespace EnumType;

/**
 * This class stands for DokumentTowarzyszacyRodzajEnum EnumType
 * @subpackage Enumerations
 */
class DokumentTowarzyszacyRodzajEnum
{
    /**
     * Constant for value 'LICENCJA'
     * @return string 'LICENCJA'
     */
    const VALUE_LICENCJA = 'LICENCJA';
    /**
     * Constant for value 'CERTYFIKAT'
     * @return string 'CERTYFIKAT'
     */
    const VALUE_CERTYFIKAT = 'CERTYFIKAT';
    /**
     * Constant for value 'FAKTURA'
     * @return string 'FAKTURA'
     */
    const VALUE_FAKTURA = 'FAKTURA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LICENCJA
     * @uses self::VALUE_CERTYFIKAT
     * @uses self::VALUE_FAKTURA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LICENCJA,
            self::VALUE_CERTYFIKAT,
            self::VALUE_FAKTURA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
