<?php

namespace EnumType;

/**
 * This class stands for DeklaracaCelnaRodzajEnum EnumType
 * @subpackage Enumerations
 */
class DeklaracaCelnaRodzajEnum
{
    /**
     * Constant for value 'CN22'
     * @return string 'CN22'
     */
    const VALUE_CN_22 = 'CN22';
    /**
     * Constant for value 'CN23'
     * @return string 'CN23'
     */
    const VALUE_CN_23 = 'CN23';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CN_22
     * @uses self::VALUE_CN_23
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CN_22,
            self::VALUE_CN_23,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
