<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEnvelopeStatusResponse StructType
 * @subpackage Structs
 */
class GetEnvelopeStatusResponse extends AbstractStructBase
{
    /**
     * The envelopeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $envelopeStatus;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for getEnvelopeStatusResponse
     * @uses GetEnvelopeStatusResponse::setEnvelopeStatus()
     * @uses GetEnvelopeStatusResponse::setError()
     * @param string $envelopeStatus
     * @param \StructType\ErrorType[] $error
     */
    public function __construct($envelopeStatus = null, array $error = array())
    {
        $this
            ->setEnvelopeStatus($envelopeStatus)
            ->setError($error);
    }
    /**
     * Get envelopeStatus value
     * @return string|null
     */
    public function getEnvelopeStatus()
    {
        return $this->envelopeStatus;
    }
    /**
     * Set envelopeStatus value
     * @uses \EnumType\EnvelopeStatusType::valueIsValid()
     * @uses \EnumType\EnvelopeStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $envelopeStatus
     * @return \StructType\GetEnvelopeStatusResponse
     */
    public function setEnvelopeStatus($envelopeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvelopeStatusType::valueIsValid($envelopeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnvelopeStatusType', is_array($envelopeStatus) ? implode(', ', $envelopeStatus) : var_export($envelopeStatus, true), implode(', ', \EnumType\EnvelopeStatusType::getValidValues())), __LINE__);
        }
        $this->envelopeStatus = $envelopeStatus;
        return $this;
    }
    /**
     * Get error value
     * @return \StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEnvelopeStatusResponseErrorItem) {
            // validation for constraint: itemType
            if (!$getEnvelopeStatusResponseErrorItem instanceof \StructType\ErrorType) {
                $invalidValues[] = is_object($getEnvelopeStatusResponseErrorItem) ? get_class($getEnvelopeStatusResponseErrorItem) : sprintf('%s(%s)', gettype($getEnvelopeStatusResponseErrorItem), var_export($getEnvelopeStatusResponseErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The error property can only contain items of type \StructType\ErrorType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType[] $error
     * @return \StructType\GetEnvelopeStatusResponse
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorType $item
     * @return \StructType\GetEnvelopeStatusResponse
     */
    public function addToError(\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of type \StructType\ErrorType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEnvelopeStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
