<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEnvelopeBufor $parameters
     * @return \StructType\UpdateEnvelopeBuforResponse|bool
     */
    public function updateEnvelopeBufor(\StructType\UpdateEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAccount $parameters
     * @return \StructType\UpdateAccountResponse|bool
     */
    public function updateAccount(\StructType\UpdateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateProfil $parameters
     * @return \StructType\UpdateProfilResponse|bool
     */
    public function updateProfil(\StructType\UpdateProfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateShopEZwroty $parameters
     * @return \StructType\UpdateShopEZwrotyResponse|bool
     */
    public function updateShopEZwroty(\StructType\UpdateShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateAccountResponse|\StructType\UpdateEnvelopeBuforResponse|\StructType\UpdateProfilResponse|\StructType\UpdateShopEZwrotyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
