<?php

namespace EnumType;

/**
 * This class stands for terminZwrotDokumentowPaczkowaType EnumType
 * @subpackage Enumerations
 */
class TerminZwrotDokumentowPaczkowaType
{
    /**
     * Constant for value 'PACZKA_24'
     * @return string 'PACZKA_24'
     */
    const VALUE_PACZKA_24 = 'PACZKA_24';
    /**
     * Constant for value 'PACZKA_48'
     * @return string 'PACZKA_48'
     */
    const VALUE_PACZKA_48 = 'PACZKA_48';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PACZKA_24
     * @uses self::VALUE_PACZKA_48
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PACZKA_24,
            self::VALUE_PACZKA_48,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
