<?php

namespace EnumType;

/**
 * This class stands for statusZgodyEZwrotNameType EnumType
 * @subpackage Enumerations
 */
class StatusZgodyEZwrotNameType
{
    /**
     * Constant for value 'NOWY'
     * @return string 'NOWY'
     */
    const VALUE_NOWY = 'NOWY';
    /**
     * Constant for value 'ZAAKCEPTOWANY'
     * @return string 'ZAAKCEPTOWANY'
     */
    const VALUE_ZAAKCEPTOWANY = 'ZAAKCEPTOWANY';
    /**
     * Constant for value 'ODRZUCONY'
     * @return string 'ODRZUCONY'
     */
    const VALUE_ODRZUCONY = 'ODRZUCONY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOWY
     * @uses self::VALUE_ZAAKCEPTOWANY
     * @uses self::VALUE_ODRZUCONY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOWY,
            self::VALUE_ZAAKCEPTOWANY,
            self::VALUE_ODRZUCONY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
