<?php

namespace EnumType;

/**
 * This class stands for statusPaczkaKorzysciType EnumType
 * @subpackage Enumerations
 */
class StatusPaczkaKorzysciType
{
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'NIEAKTYWNA'
     * @return string 'NIEAKTYWNA'
     */
    const VALUE_NIEAKTYWNA = 'NIEAKTYWNA';
    /**
     * Constant for value 'AKTYWNA'
     * @return string 'AKTYWNA'
     */
    const VALUE_AKTYWNA = 'AKTYWNA';
    /**
     * Constant for value 'PRZETERMINOWANA'
     * @return string 'PRZETERMINOWANA'
     */
    const VALUE_PRZETERMINOWANA = 'PRZETERMINOWANA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_NIEAKTYWNA
     * @uses self::VALUE_AKTYWNA
     * @uses self::VALUE_PRZETERMINOWANA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERROR,
            self::VALUE_NIEAKTYWNA,
            self::VALUE_AKTYWNA,
            self::VALUE_PRZETERMINOWANA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
