<?php

namespace EnumType;

/**
 * This class stands for statusAccountType EnumType
 * @subpackage Enumerations
 */
class StatusAccountType
{
    /**
     * Constant for value 'WYLACZONY'
     * @return string 'WYLACZONY'
     */
    const VALUE_WYLACZONY = 'WYLACZONY';
    /**
     * Constant for value 'ZABLOKOWANY'
     * @return string 'ZABLOKOWANY'
     */
    const VALUE_ZABLOKOWANY = 'ZABLOKOWANY';
    /**
     * Constant for value 'ODBLOKOWANY'
     * @return string 'ODBLOKOWANY'
     */
    const VALUE_ODBLOKOWANY = 'ODBLOKOWANY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WYLACZONY
     * @uses self::VALUE_ZABLOKOWANY
     * @uses self::VALUE_ODBLOKOWANY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WYLACZONY,
            self::VALUE_ZABLOKOWANY,
            self::VALUE_ODBLOKOWANY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
