<?php

namespace EnumType;

/**
 * This class stands for sposobZwrotuType EnumType
 * @subpackage Enumerations
 */
class SposobZwrotuType
{
    /**
     * Constant for value 'LADOWO_MORSKA'
     * @return string 'LADOWO_MORSKA'
     */
    const VALUE_LADOWO_MORSKA = 'LADOWO_MORSKA';
    /**
     * Constant for value 'LOTNICZA'
     * @return string 'LOTNICZA'
     */
    const VALUE_LOTNICZA = 'LOTNICZA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LADOWO_MORSKA
     * @uses self::VALUE_LOTNICZA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LADOWO_MORSKA,
            self::VALUE_LOTNICZA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
