<?php

namespace EnumType;

/**
 * This class stands for sposobPrzekazaniaType EnumType
 * @subpackage Enumerations
 */
class SposobPrzekazaniaType
{
    /**
     * Constant for value 'LIST_ZWYKLY_PRIOTYTET'
     * @return string 'LIST_ZWYKLY_PRIOTYTET'
     */
    const VALUE_LIST_ZWYKLY_PRIOTYTET = 'LIST_ZWYKLY_PRIOTYTET';
    /**
     * Constant for value 'POCZTEX'
     * @return string 'POCZTEX'
     */
    const VALUE_POCZTEX = 'POCZTEX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LIST_ZWYKLY_PRIOTYTET
     * @uses self::VALUE_POCZTEX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIST_ZWYKLY_PRIOTYTET,
            self::VALUE_POCZTEX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
