<?php

namespace EnumType;

/**
 * This class stands for sposobDoreczeniaPotwierdzeniaType EnumType
 * @subpackage Enumerations
 */
class SposobDoreczeniaPotwierdzeniaType
{
    /**
     * Constant for value 'TELEFON'
     * @return string 'TELEFON'
     */
    const VALUE_TELEFON = 'TELEFON';
    /**
     * Constant for value 'TELEFAX'
     * @return string 'TELEFAX'
     */
    const VALUE_TELEFAX = 'TELEFAX';
    /**
     * Constant for value 'SMS'
     * @return string 'SMS'
     */
    const VALUE_SMS = 'SMS';
    /**
     * Constant for value 'EMAIL'
     * @return string 'EMAIL'
     */
    const VALUE_EMAIL = 'EMAIL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TELEFON
     * @uses self::VALUE_TELEFAX
     * @uses self::VALUE_SMS
     * @uses self::VALUE_EMAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TELEFON,
            self::VALUE_TELEFAX,
            self::VALUE_SMS,
            self::VALUE_EMAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
