<?php

namespace EnumType;

/**
 * This class stands for siecPlacowekEnum EnumType
 * Meta information extracted from the WSDL
 * - documentation: Okresla do jakiej sieci nalezy placowka
 * @subpackage Enumerations
 */
class SiecPlacowekEnum
{
    /**
     * Constant for value 'POCZTAPOLSKA'
     * @return string 'POCZTAPOLSKA'
     */
    const VALUE_POCZTAPOLSKA = 'POCZTAPOLSKA';
    /**
     * Constant for value 'ORLEN'
     * @return string 'ORLEN'
     */
    const VALUE_ORLEN = 'ORLEN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_POCZTAPOLSKA
     * @uses self::VALUE_ORLEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_POCZTAPOLSKA,
            self::VALUE_ORLEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
