<?php

namespace EnumType;

/**
 * This class stands for rodzajPaletyType EnumType
 * @subpackage Enumerations
 */
class RodzajPaletyType
{
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const VALUE_EUR = 'EUR';
    /**
     * Constant for value 'POLPALETA'
     * @return string 'POLPALETA'
     */
    const VALUE_POLPALETA = 'POLPALETA';
    /**
     * Constant for value 'INNA'
     * @return string 'INNA'
     */
    const VALUE_INNA = 'INNA';
    /**
     * Constant for value 'PRZEMYSLOWA'
     * @return string 'PRZEMYSLOWA'
     */
    const VALUE_PRZEMYSLOWA = 'PRZEMYSLOWA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EUR
     * @uses self::VALUE_POLPALETA
     * @uses self::VALUE_INNA
     * @uses self::VALUE_PRZEMYSLOWA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EUR,
            self::VALUE_POLPALETA,
            self::VALUE_INNA,
            self::VALUE_PRZEMYSLOWA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
