<?php

namespace EnumType;

/**
 * This class stands for relatedToAllegroChannelType EnumType
 * @subpackage Enumerations
 */
class RelatedToAllegroChannelType
{
    /**
     * Constant for value 'MS'
     * @return string 'MS'
     */
    const VALUE_MS = 'MS';
    /**
     * Constant for value 'WEB_API'
     * @return string 'WEB_API'
     */
    const VALUE_WEB_API = 'WEB_API';
    /**
     * Constant for value 'REST_API'
     * @return string 'REST_API'
     */
    const VALUE_REST_API = 'REST_API';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MS
     * @uses self::VALUE_WEB_API
     * @uses self::VALUE_REST_API
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MS,
            self::VALUE_WEB_API,
            self::VALUE_REST_API,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
