<?php

namespace EnumType;

/**
 * This class stands for formatType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Określa format przesyłki. Format S: Maksymalne wymiary koperty [mm]: 160 x 230 x 20. Maksymalna waga [g]: 500 Format M: Maksymalne wymiary koperty [mm]: 230 x 325 x 20. Maksymalna waga [g]: 1000 Format L: Maksymalna suma wymiarów
 * koperty [mm]: 900. Maksymalna długość najdłuższego boku [mm]: 600 Rulony Maksymalna waga [g]: 2000
 * @subpackage Enumerations
 */
class FormatType
{
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'M'
     * @return string 'M'
     */
    const VALUE_M = 'M';
    /**
     * Constant for value 'L'
     * @return string 'L'
     */
    const VALUE_L = 'L';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_S
     * @uses self::VALUE_M
     * @uses self::VALUE_L
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_S,
            self::VALUE_M,
            self::VALUE_L,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
