<?php

namespace EnumType;

/**
 * This class stands for eZwrotPrzesylkiType EnumType
 * @subpackage Enumerations
 */
class EZwrotPrzesylkiType
{
    /**
     * Constant for value 'ZWROTPACZKA48'
     * @return string 'ZWROTPACZKA48'
     */
    const VALUE_ZWROTPACZKA_48 = 'ZWROTPACZKA48';
    /**
     * Constant for value 'ZWROTKURIEREKSPRES24'
     * @return string 'ZWROTKURIEREKSPRES24'
     */
    const VALUE_ZWROTKURIEREKSPRES_24 = 'ZWROTKURIEREKSPRES24';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ZWROTPACZKA_48
     * @uses self::VALUE_ZWROTKURIEREKSPRES_24
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ZWROTPACZKA_48,
            self::VALUE_ZWROTKURIEREKSPRES_24,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
