<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isPostalCodeValid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsPostalCodeValid $parameters
     * @return \StructType\IsPostalCodeValidResponse|bool
     */
    public function isPostalCodeValid(\StructType\IsPostalCodeValid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isPostalCodeValid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isAlternativeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsAlternativeService $parameters
     * @return \StructType\IsAlternativeServiceResponse|bool
     */
    public function isAlternativeService(\StructType\IsAlternativeService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isAlternativeService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isResidential
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsResidential $parameters
     * @return \StructType\IsResidentialResponse|bool
     */
    public function isResidential(\StructType\IsResidential $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isResidential($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IsAlternativeServiceResponse|\StructType\IsPostalCodeValidResponse|\StructType\IsResidentialResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
