<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rate ServiceType
 * @subpackage Services
 */
class Rate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rateShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RateShipment $parameters
     * @return \StructType\RateShipmentResponse|bool
     */
    public function rateShipment(\StructType\RateShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rateShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named rateShipmentAllServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RateShipmentAllServices $parameters
     * @return \StructType\RateShipmentAllServicesResponse|bool
     */
    public function rateShipmentAllServices(\StructType\RateShipmentAllServices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rateShipmentAllServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named rateShipmentAllPremiums
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RateShipmentAllPremiums $parameters
     * @return \StructType\RateShipmentAllPremiumsResponse|bool
     */
    public function rateShipmentAllPremiums(\StructType\RateShipmentAllPremiums $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rateShipmentAllPremiums($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RateShipmentAllPremiumsResponse|\StructType\RateShipmentAllServicesResponse|\StructType\RateShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
