<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTicketType StructType
 * @subpackage Structs
 */
class UpdateTicketType extends AbstractStructBase
{
    /**
     * The tId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $tId;
    /**
     * The tStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tStatus;
    /**
     * The tSeverity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tSeverity;
    /**
     * The tDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tDescription;
    /**
     * The tAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tAnswer;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ContactType
     */
    public $contact;
    /**
     * The subscriptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionId;
    /**
     * The subscriptionEndPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionEndPointType
     */
    public $subscriptionEndPoint;
    /**
     * The breakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $breakout;
    /**
     * Constructor method for UpdateTicketType
     * @uses UpdateTicketType::setTId()
     * @uses UpdateTicketType::setTStatus()
     * @uses UpdateTicketType::setTSeverity()
     * @uses UpdateTicketType::setTDescription()
     * @uses UpdateTicketType::setTAnswer()
     * @uses UpdateTicketType::setContact()
     * @uses UpdateTicketType::setSubscriptionId()
     * @uses UpdateTicketType::setSubscriptionEndPoint()
     * @uses UpdateTicketType::setBreakout()
     * @param int $tId
     * @param string $tStatus
     * @param string $tSeverity
     * @param string $tDescription
     * @param string $tAnswer
     * @param \StructType\ContactType $contact
     * @param string $subscriptionId
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @param \StructType\L1BreakoutType $breakout
     */
    public function __construct($tId = null, $tStatus = null, $tSeverity = null, $tDescription = null, $tAnswer = null, \StructType\ContactType $contact = null, $subscriptionId = null, \StructType\SubscriptionEndPointType $subscriptionEndPoint = null, \StructType\L1BreakoutType $breakout = null)
    {
        $this
            ->setTId($tId)
            ->setTStatus($tStatus)
            ->setTSeverity($tSeverity)
            ->setTDescription($tDescription)
            ->setTAnswer($tAnswer)
            ->setContact($contact)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionEndPoint($subscriptionEndPoint)
            ->setBreakout($breakout);
    }
    /**
     * Get tId value
     * @return int
     */
    public function getTId()
    {
        return $this->tId;
    }
    /**
     * Set tId value
     * @param int $tId
     * @return \StructType\UpdateTicketType
     */
    public function setTId($tId = null)
    {
        // validation for constraint: int
        if (!is_null($tId) && !(is_int($tId) || ctype_digit($tId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tId, true), gettype($tId)), __LINE__);
        }
        $this->tId = $tId;
        return $this;
    }
    /**
     * Get tStatus value
     * @return string|null
     */
    public function getTStatus()
    {
        return $this->tStatus;
    }
    /**
     * Set tStatus value
     * @uses \EnumType\TStatus::valueIsValid()
     * @uses \EnumType\TStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tStatus
     * @return \StructType\UpdateTicketType
     */
    public function setTStatus($tStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TStatus::valueIsValid($tStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TStatus', is_array($tStatus) ? implode(', ', $tStatus) : var_export($tStatus, true), implode(', ', \EnumType\TStatus::getValidValues())), __LINE__);
        }
        $this->tStatus = $tStatus;
        return $this;
    }
    /**
     * Get tSeverity value
     * @return string|null
     */
    public function getTSeverity()
    {
        return $this->tSeverity;
    }
    /**
     * Set tSeverity value
     * @uses \EnumType\TSeverity::valueIsValid()
     * @uses \EnumType\TSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tSeverity
     * @return \StructType\UpdateTicketType
     */
    public function setTSeverity($tSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TSeverity::valueIsValid($tSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TSeverity', is_array($tSeverity) ? implode(', ', $tSeverity) : var_export($tSeverity, true), implode(', ', \EnumType\TSeverity::getValidValues())), __LINE__);
        }
        $this->tSeverity = $tSeverity;
        return $this;
    }
    /**
     * Get tDescription value
     * @return string|null
     */
    public function getTDescription()
    {
        return $this->tDescription;
    }
    /**
     * Set tDescription value
     * @param string $tDescription
     * @return \StructType\UpdateTicketType
     */
    public function setTDescription($tDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tDescription) && !is_string($tDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tDescription, true), gettype($tDescription)), __LINE__);
        }
        $this->tDescription = $tDescription;
        return $this;
    }
    /**
     * Get tAnswer value
     * @return string|null
     */
    public function getTAnswer()
    {
        return $this->tAnswer;
    }
    /**
     * Set tAnswer value
     * @param string $tAnswer
     * @return \StructType\UpdateTicketType
     */
    public function setTAnswer($tAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($tAnswer) && !is_string($tAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tAnswer, true), gettype($tAnswer)), __LINE__);
        }
        $this->tAnswer = $tAnswer;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\ContactType $contact
     * @return \StructType\UpdateTicketType
     */
    public function setContact(\StructType\ContactType $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get subscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->subscriptionId;
    }
    /**
     * Set subscriptionId value
     * @param string $subscriptionId
     * @return \StructType\UpdateTicketType
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        $this->subscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get subscriptionEndPoint value
     * @return \StructType\SubscriptionEndPointType|null
     */
    public function getSubscriptionEndPoint()
    {
        return $this->subscriptionEndPoint;
    }
    /**
     * Set subscriptionEndPoint value
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @return \StructType\UpdateTicketType
     */
    public function setSubscriptionEndPoint(\StructType\SubscriptionEndPointType $subscriptionEndPoint = null)
    {
        $this->subscriptionEndPoint = $subscriptionEndPoint;
        return $this;
    }
    /**
     * Get breakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getBreakout()
    {
        return $this->breakout;
    }
    /**
     * Set breakout value
     * @param \StructType\L1BreakoutType $breakout
     * @return \StructType\UpdateTicketType
     */
    public function setBreakout(\StructType\L1BreakoutType $breakout = null)
    {
        $this->breakout = $breakout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateTicketType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
