<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateSubscriptionRequestAlap StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-P request description for the method "updateSubscription".
 * @subpackage Structs
 */
class UpdateSubscriptionRequestAlap extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\SubscriptionType
     */
    public $subscription;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusTypeAlap
     */
    public $focus;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reason;
    /**
     * Constructor method for updateSubscriptionRequestAlap
     * @uses UpdateSubscriptionRequestAlap::setAuthentication()
     * @uses UpdateSubscriptionRequestAlap::setSubscription()
     * @uses UpdateSubscriptionRequestAlap::setFocus()
     * @uses UpdateSubscriptionRequestAlap::setReason()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\SubscriptionType $subscription
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @param string $reason
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\SubscriptionType $subscription = null, \StructType\AlexBusinessFocusTypeAlap $focus = null, $reason = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setSubscription($subscription)
            ->setFocus($focus)
            ->setReason($reason);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\UpdateSubscriptionRequestAlap
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\SubscriptionType
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\SubscriptionType $subscription
     * @return \StructType\UpdateSubscriptionRequestAlap
     */
    public function setSubscription(\StructType\SubscriptionType $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusTypeAlap|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @return \StructType\UpdateSubscriptionRequestAlap
     */
    public function setFocus(\StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\UpdateSubscriptionRequestAlap
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSubscriptionRequestAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
