<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketType StructType
 * Meta information extracted from the WSDL
 * - documentation: Represents an assurance ticket.
 * @subpackage Structs
 */
class TicketType extends AbstractStructBase
{
    /**
     * The tId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $tId;
    /**
     * The tExternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tExternalReference;
    /**
     * The tCreator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tCreator;
    /**
     * The tStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tStatus;
    /**
     * The tType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tType;
    /**
     * The tSeverity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tSeverity;
    /**
     * The tCreationTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tCreationTimestamp;
    /**
     * The lastModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lastModified;
    /**
     * The tSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tSubject;
    /**
     * The tDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tDescription;
    /**
     * The tAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tAnswer;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ContactType
     */
    public $contact;
    /**
     * The subscriptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionId;
    /**
     * The subscriptionEndPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionEndPointType
     */
    public $subscriptionEndPoint;
    /**
     * The breakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $breakout;
    /**
     * The tCauser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tCauser;
    /**
     * The resolutionCode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $resolutionCode1;
    /**
     * The resolutionCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $resolutionCode2;
    /**
     * The resolutionCode3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $resolutionCode3;
    /**
     * Constructor method for TicketType
     * @uses TicketType::setTId()
     * @uses TicketType::setTExternalReference()
     * @uses TicketType::setTCreator()
     * @uses TicketType::setTStatus()
     * @uses TicketType::setTType()
     * @uses TicketType::setTSeverity()
     * @uses TicketType::setTCreationTimestamp()
     * @uses TicketType::setLastModified()
     * @uses TicketType::setTSubject()
     * @uses TicketType::setTDescription()
     * @uses TicketType::setTAnswer()
     * @uses TicketType::setContact()
     * @uses TicketType::setSubscriptionId()
     * @uses TicketType::setSubscriptionEndPoint()
     * @uses TicketType::setBreakout()
     * @uses TicketType::setTCauser()
     * @uses TicketType::setResolutionCode1()
     * @uses TicketType::setResolutionCode2()
     * @uses TicketType::setResolutionCode3()
     * @param int $tId
     * @param string $tExternalReference
     * @param string $tCreator
     * @param string $tStatus
     * @param string $tType
     * @param string $tSeverity
     * @param string $tCreationTimestamp
     * @param string $lastModified
     * @param string $tSubject
     * @param string $tDescription
     * @param string $tAnswer
     * @param \StructType\ContactType $contact
     * @param string $subscriptionId
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @param \StructType\L1BreakoutType $breakout
     * @param string $tCauser
     * @param string $resolutionCode1
     * @param string $resolutionCode2
     * @param string $resolutionCode3
     */
    public function __construct($tId = null, $tExternalReference = null, $tCreator = null, $tStatus = null, $tType = null, $tSeverity = null, $tCreationTimestamp = null, $lastModified = null, $tSubject = null, $tDescription = null, $tAnswer = null, \StructType\ContactType $contact = null, $subscriptionId = null, \StructType\SubscriptionEndPointType $subscriptionEndPoint = null, \StructType\L1BreakoutType $breakout = null, $tCauser = null, $resolutionCode1 = null, $resolutionCode2 = null, $resolutionCode3 = null)
    {
        $this
            ->setTId($tId)
            ->setTExternalReference($tExternalReference)
            ->setTCreator($tCreator)
            ->setTStatus($tStatus)
            ->setTType($tType)
            ->setTSeverity($tSeverity)
            ->setTCreationTimestamp($tCreationTimestamp)
            ->setLastModified($lastModified)
            ->setTSubject($tSubject)
            ->setTDescription($tDescription)
            ->setTAnswer($tAnswer)
            ->setContact($contact)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionEndPoint($subscriptionEndPoint)
            ->setBreakout($breakout)
            ->setTCauser($tCauser)
            ->setResolutionCode1($resolutionCode1)
            ->setResolutionCode2($resolutionCode2)
            ->setResolutionCode3($resolutionCode3);
    }
    /**
     * Get tId value
     * @return int|null
     */
    public function getTId()
    {
        return $this->tId;
    }
    /**
     * Set tId value
     * @param int $tId
     * @return \StructType\TicketType
     */
    public function setTId($tId = null)
    {
        // validation for constraint: int
        if (!is_null($tId) && !(is_int($tId) || ctype_digit($tId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tId, true), gettype($tId)), __LINE__);
        }
        $this->tId = $tId;
        return $this;
    }
    /**
     * Get tExternalReference value
     * @return string|null
     */
    public function getTExternalReference()
    {
        return $this->tExternalReference;
    }
    /**
     * Set tExternalReference value
     * @param string $tExternalReference
     * @return \StructType\TicketType
     */
    public function setTExternalReference($tExternalReference = null)
    {
        // validation for constraint: string
        if (!is_null($tExternalReference) && !is_string($tExternalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tExternalReference, true), gettype($tExternalReference)), __LINE__);
        }
        $this->tExternalReference = $tExternalReference;
        return $this;
    }
    /**
     * Get tCreator value
     * @return string|null
     */
    public function getTCreator()
    {
        return $this->tCreator;
    }
    /**
     * Set tCreator value
     * @param string $tCreator
     * @return \StructType\TicketType
     */
    public function setTCreator($tCreator = null)
    {
        // validation for constraint: string
        if (!is_null($tCreator) && !is_string($tCreator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCreator, true), gettype($tCreator)), __LINE__);
        }
        $this->tCreator = $tCreator;
        return $this;
    }
    /**
     * Get tStatus value
     * @return string|null
     */
    public function getTStatus()
    {
        return $this->tStatus;
    }
    /**
     * Set tStatus value
     * @uses \EnumType\TStatus::valueIsValid()
     * @uses \EnumType\TStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tStatus
     * @return \StructType\TicketType
     */
    public function setTStatus($tStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TStatus::valueIsValid($tStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TStatus', is_array($tStatus) ? implode(', ', $tStatus) : var_export($tStatus, true), implode(', ', \EnumType\TStatus::getValidValues())), __LINE__);
        }
        $this->tStatus = $tStatus;
        return $this;
    }
    /**
     * Get tType value
     * @return string|null
     */
    public function getTType()
    {
        return $this->tType;
    }
    /**
     * Set tType value
     * @uses \EnumType\TType::valueIsValid()
     * @uses \EnumType\TType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tType
     * @return \StructType\TicketType
     */
    public function setTType($tType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TType::valueIsValid($tType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TType', is_array($tType) ? implode(', ', $tType) : var_export($tType, true), implode(', ', \EnumType\TType::getValidValues())), __LINE__);
        }
        $this->tType = $tType;
        return $this;
    }
    /**
     * Get tSeverity value
     * @return string|null
     */
    public function getTSeverity()
    {
        return $this->tSeverity;
    }
    /**
     * Set tSeverity value
     * @uses \EnumType\TSeverity::valueIsValid()
     * @uses \EnumType\TSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tSeverity
     * @return \StructType\TicketType
     */
    public function setTSeverity($tSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TSeverity::valueIsValid($tSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TSeverity', is_array($tSeverity) ? implode(', ', $tSeverity) : var_export($tSeverity, true), implode(', ', \EnumType\TSeverity::getValidValues())), __LINE__);
        }
        $this->tSeverity = $tSeverity;
        return $this;
    }
    /**
     * Get tCreationTimestamp value
     * @return string|null
     */
    public function getTCreationTimestamp()
    {
        return $this->tCreationTimestamp;
    }
    /**
     * Set tCreationTimestamp value
     * @param string $tCreationTimestamp
     * @return \StructType\TicketType
     */
    public function setTCreationTimestamp($tCreationTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($tCreationTimestamp) && !is_string($tCreationTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCreationTimestamp, true), gettype($tCreationTimestamp)), __LINE__);
        }
        $this->tCreationTimestamp = $tCreationTimestamp;
        return $this;
    }
    /**
     * Get lastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->lastModified;
    }
    /**
     * Set lastModified value
     * @param string $lastModified
     * @return \StructType\TicketType
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->lastModified = $lastModified;
        return $this;
    }
    /**
     * Get tSubject value
     * @return string|null
     */
    public function getTSubject()
    {
        return $this->tSubject;
    }
    /**
     * Set tSubject value
     * @param string $tSubject
     * @return \StructType\TicketType
     */
    public function setTSubject($tSubject = null)
    {
        // validation for constraint: string
        if (!is_null($tSubject) && !is_string($tSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tSubject, true), gettype($tSubject)), __LINE__);
        }
        $this->tSubject = $tSubject;
        return $this;
    }
    /**
     * Get tDescription value
     * @return string|null
     */
    public function getTDescription()
    {
        return $this->tDescription;
    }
    /**
     * Set tDescription value
     * @param string $tDescription
     * @return \StructType\TicketType
     */
    public function setTDescription($tDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tDescription) && !is_string($tDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tDescription, true), gettype($tDescription)), __LINE__);
        }
        $this->tDescription = $tDescription;
        return $this;
    }
    /**
     * Get tAnswer value
     * @return string|null
     */
    public function getTAnswer()
    {
        return $this->tAnswer;
    }
    /**
     * Set tAnswer value
     * @param string $tAnswer
     * @return \StructType\TicketType
     */
    public function setTAnswer($tAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($tAnswer) && !is_string($tAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tAnswer, true), gettype($tAnswer)), __LINE__);
        }
        $this->tAnswer = $tAnswer;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\ContactType $contact
     * @return \StructType\TicketType
     */
    public function setContact(\StructType\ContactType $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get subscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->subscriptionId;
    }
    /**
     * Set subscriptionId value
     * @param string $subscriptionId
     * @return \StructType\TicketType
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        $this->subscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get subscriptionEndPoint value
     * @return \StructType\SubscriptionEndPointType|null
     */
    public function getSubscriptionEndPoint()
    {
        return $this->subscriptionEndPoint;
    }
    /**
     * Set subscriptionEndPoint value
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @return \StructType\TicketType
     */
    public function setSubscriptionEndPoint(\StructType\SubscriptionEndPointType $subscriptionEndPoint = null)
    {
        $this->subscriptionEndPoint = $subscriptionEndPoint;
        return $this;
    }
    /**
     * Get breakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getBreakout()
    {
        return $this->breakout;
    }
    /**
     * Set breakout value
     * @param \StructType\L1BreakoutType $breakout
     * @return \StructType\TicketType
     */
    public function setBreakout(\StructType\L1BreakoutType $breakout = null)
    {
        $this->breakout = $breakout;
        return $this;
    }
    /**
     * Get tCauser value
     * @return string|null
     */
    public function getTCauser()
    {
        return $this->tCauser;
    }
    /**
     * Set tCauser value
     * @param string $tCauser
     * @return \StructType\TicketType
     */
    public function setTCauser($tCauser = null)
    {
        // validation for constraint: string
        if (!is_null($tCauser) && !is_string($tCauser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCauser, true), gettype($tCauser)), __LINE__);
        }
        $this->tCauser = $tCauser;
        return $this;
    }
    /**
     * Get resolutionCode1 value
     * @return string|null
     */
    public function getResolutionCode1()
    {
        return $this->resolutionCode1;
    }
    /**
     * Set resolutionCode1 value
     * @param string $resolutionCode1
     * @return \StructType\TicketType
     */
    public function setResolutionCode1($resolutionCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($resolutionCode1) && !is_string($resolutionCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolutionCode1, true), gettype($resolutionCode1)), __LINE__);
        }
        $this->resolutionCode1 = $resolutionCode1;
        return $this;
    }
    /**
     * Get resolutionCode2 value
     * @return string|null
     */
    public function getResolutionCode2()
    {
        return $this->resolutionCode2;
    }
    /**
     * Set resolutionCode2 value
     * @param string $resolutionCode2
     * @return \StructType\TicketType
     */
    public function setResolutionCode2($resolutionCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($resolutionCode2) && !is_string($resolutionCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolutionCode2, true), gettype($resolutionCode2)), __LINE__);
        }
        $this->resolutionCode2 = $resolutionCode2;
        return $this;
    }
    /**
     * Get resolutionCode3 value
     * @return string|null
     */
    public function getResolutionCode3()
    {
        return $this->resolutionCode3;
    }
    /**
     * Set resolutionCode3 value
     * @param string $resolutionCode3
     * @return \StructType\TicketType
     */
    public function setResolutionCode3($resolutionCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($resolutionCode3) && !is_string($resolutionCode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolutionCode3, true), gettype($resolutionCode3)), __LINE__);
        }
        $this->resolutionCode3 = $resolutionCode3;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
