<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionType StructType
 * @subpackage Structs
 */
class SubscriptionType extends AbstractStructBase
{
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ServiceType
     */
    public $service;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ContactType
     */
    public $contact;
    /**
     * The subscriptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionId;
    /**
     * The subscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionEndPointId;
    /**
     * The sfSla
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sfSla;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $status;
    /**
     * The wishDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $wishDate;
    /**
     * The switchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $switchDate;
    /**
     * The modificationDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $modificationDateTime;
    /**
     * The subscriptionLog
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionLogType
     */
    public $subscriptionLog;
    /**
     * The l1HandoverEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1HandoverEquipmentType
     */
    public $l1HandoverEquipment;
    /**
     * The l1Breakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $l1Breakout;
    /**
     * The alauOrderRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alauOrderRef;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $note;
    /**
     * Constructor method for SubscriptionType
     * @uses SubscriptionType::setService()
     * @uses SubscriptionType::setContact()
     * @uses SubscriptionType::setSubscriptionId()
     * @uses SubscriptionType::setSubscriptionEndPointId()
     * @uses SubscriptionType::setSfSla()
     * @uses SubscriptionType::setStatus()
     * @uses SubscriptionType::setWishDate()
     * @uses SubscriptionType::setSwitchDate()
     * @uses SubscriptionType::setModificationDateTime()
     * @uses SubscriptionType::setSubscriptionLog()
     * @uses SubscriptionType::setL1HandoverEquipment()
     * @uses SubscriptionType::setL1Breakout()
     * @uses SubscriptionType::setAlauOrderRef()
     * @uses SubscriptionType::setNote()
     * @param \StructType\ServiceType $service
     * @param \StructType\ContactType $contact
     * @param string $subscriptionId
     * @param string $subscriptionEndPointId
     * @param string $sfSla
     * @param string $status
     * @param string $wishDate
     * @param string $switchDate
     * @param string $modificationDateTime
     * @param \StructType\SubscriptionLogType $subscriptionLog
     * @param \StructType\L1HandoverEquipmentType $l1HandoverEquipment
     * @param \StructType\L1BreakoutType $l1Breakout
     * @param string $alauOrderRef
     * @param string $note
     */
    public function __construct(\StructType\ServiceType $service = null, \StructType\ContactType $contact = null, $subscriptionId = null, $subscriptionEndPointId = null, $sfSla = null, $status = null, $wishDate = null, $switchDate = null, $modificationDateTime = null, \StructType\SubscriptionLogType $subscriptionLog = null, \StructType\L1HandoverEquipmentType $l1HandoverEquipment = null, \StructType\L1BreakoutType $l1Breakout = null, $alauOrderRef = null, $note = null)
    {
        $this
            ->setService($service)
            ->setContact($contact)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionEndPointId($subscriptionEndPointId)
            ->setSfSla($sfSla)
            ->setStatus($status)
            ->setWishDate($wishDate)
            ->setSwitchDate($switchDate)
            ->setModificationDateTime($modificationDateTime)
            ->setSubscriptionLog($subscriptionLog)
            ->setL1HandoverEquipment($l1HandoverEquipment)
            ->setL1Breakout($l1Breakout)
            ->setAlauOrderRef($alauOrderRef)
            ->setNote($note);
    }
    /**
     * Get service value
     * @return \StructType\ServiceType|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param \StructType\ServiceType $service
     * @return \StructType\SubscriptionType
     */
    public function setService(\StructType\ServiceType $service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\ContactType $contact
     * @return \StructType\SubscriptionType
     */
    public function setContact(\StructType\ContactType $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get subscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->subscriptionId;
    }
    /**
     * Set subscriptionId value
     * @param string $subscriptionId
     * @return \StructType\SubscriptionType
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        $this->subscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get subscriptionEndPointId value
     * @return string|null
     */
    public function getSubscriptionEndPointId()
    {
        return $this->subscriptionEndPointId;
    }
    /**
     * Set subscriptionEndPointId value
     * @param string $subscriptionEndPointId
     * @return \StructType\SubscriptionType
     */
    public function setSubscriptionEndPointId($subscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionEndPointId) && !is_string($subscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionEndPointId, true), gettype($subscriptionEndPointId)), __LINE__);
        }
        $this->subscriptionEndPointId = $subscriptionEndPointId;
        return $this;
    }
    /**
     * Get sfSla value
     * @return string|null
     */
    public function getSfSla()
    {
        return $this->sfSla;
    }
    /**
     * Set sfSla value
     * @uses \EnumType\SfSla::valueIsValid()
     * @uses \EnumType\SfSla::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sfSla
     * @return \StructType\SubscriptionType
     */
    public function setSfSla($sfSla = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SfSla::valueIsValid($sfSla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SfSla', is_array($sfSla) ? implode(', ', $sfSla) : var_export($sfSla, true), implode(', ', \EnumType\SfSla::getValidValues())), __LINE__);
        }
        $this->sfSla = $sfSla;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SubscriptionType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Status', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\Status::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get wishDate value
     * @return string|null
     */
    public function getWishDate()
    {
        return $this->wishDate;
    }
    /**
     * Set wishDate value
     * @param string $wishDate
     * @return \StructType\SubscriptionType
     */
    public function setWishDate($wishDate = null)
    {
        // validation for constraint: string
        if (!is_null($wishDate) && !is_string($wishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wishDate, true), gettype($wishDate)), __LINE__);
        }
        $this->wishDate = $wishDate;
        return $this;
    }
    /**
     * Get switchDate value
     * @return string|null
     */
    public function getSwitchDate()
    {
        return $this->switchDate;
    }
    /**
     * Set switchDate value
     * @param string $switchDate
     * @return \StructType\SubscriptionType
     */
    public function setSwitchDate($switchDate = null)
    {
        // validation for constraint: string
        if (!is_null($switchDate) && !is_string($switchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($switchDate, true), gettype($switchDate)), __LINE__);
        }
        $this->switchDate = $switchDate;
        return $this;
    }
    /**
     * Get modificationDateTime value
     * @return string|null
     */
    public function getModificationDateTime()
    {
        return $this->modificationDateTime;
    }
    /**
     * Set modificationDateTime value
     * @param string $modificationDateTime
     * @return \StructType\SubscriptionType
     */
    public function setModificationDateTime($modificationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDateTime) && !is_string($modificationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDateTime, true), gettype($modificationDateTime)), __LINE__);
        }
        $this->modificationDateTime = $modificationDateTime;
        return $this;
    }
    /**
     * Get subscriptionLog value
     * @return \StructType\SubscriptionLogType|null
     */
    public function getSubscriptionLog()
    {
        return $this->subscriptionLog;
    }
    /**
     * Set subscriptionLog value
     * @param \StructType\SubscriptionLogType $subscriptionLog
     * @return \StructType\SubscriptionType
     */
    public function setSubscriptionLog(\StructType\SubscriptionLogType $subscriptionLog = null)
    {
        $this->subscriptionLog = $subscriptionLog;
        return $this;
    }
    /**
     * Get l1HandoverEquipment value
     * @return \StructType\L1HandoverEquipmentType|null
     */
    public function getL1HandoverEquipment()
    {
        return $this->l1HandoverEquipment;
    }
    /**
     * Set l1HandoverEquipment value
     * @param \StructType\L1HandoverEquipmentType $l1HandoverEquipment
     * @return \StructType\SubscriptionType
     */
    public function setL1HandoverEquipment(\StructType\L1HandoverEquipmentType $l1HandoverEquipment = null)
    {
        $this->l1HandoverEquipment = $l1HandoverEquipment;
        return $this;
    }
    /**
     * Get l1Breakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getL1Breakout()
    {
        return $this->l1Breakout;
    }
    /**
     * Set l1Breakout value
     * @param \StructType\L1BreakoutType $l1Breakout
     * @return \StructType\SubscriptionType
     */
    public function setL1Breakout(\StructType\L1BreakoutType $l1Breakout = null)
    {
        $this->l1Breakout = $l1Breakout;
        return $this;
    }
    /**
     * Get alauOrderRef value
     * @return string|null
     */
    public function getAlauOrderRef()
    {
        return $this->alauOrderRef;
    }
    /**
     * Set alauOrderRef value
     * @param string $alauOrderRef
     * @return \StructType\SubscriptionType
     */
    public function setAlauOrderRef($alauOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($alauOrderRef) && !is_string($alauOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alauOrderRef, true), gettype($alauOrderRef)), __LINE__);
        }
        $this->alauOrderRef = $alauOrderRef;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\SubscriptionType
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
