<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultType StructType
 * @subpackage Structs
 */
class ResultType extends ResultBasicType
{
    /**
     * The alaProviderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $alaProviderId;
    /**
     * The alaUserLocalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $alaUserLocalId;
    /**
     * The serviceDomainId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $serviceDomainId;
    /**
     * The businessDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $businessDomain;
    /**
     * Constructor method for ResultType
     * @uses ResultType::setAlaProviderId()
     * @uses ResultType::setAlaUserLocalId()
     * @uses ResultType::setServiceDomainId()
     * @uses ResultType::setBusinessDomain()
     * @param int $alaProviderId
     * @param int $alaUserLocalId
     * @param int $serviceDomainId
     * @param string $businessDomain
     */
    public function __construct($alaProviderId = null, $alaUserLocalId = null, $serviceDomainId = null, $businessDomain = null)
    {
        $this
            ->setAlaProviderId($alaProviderId)
            ->setAlaUserLocalId($alaUserLocalId)
            ->setServiceDomainId($serviceDomainId)
            ->setBusinessDomain($businessDomain);
    }
    /**
     * Get alaProviderId value
     * @return int|null
     */
    public function getAlaProviderId()
    {
        return $this->alaProviderId;
    }
    /**
     * Set alaProviderId value
     * @param int $alaProviderId
     * @return \StructType\ResultType
     */
    public function setAlaProviderId($alaProviderId = null)
    {
        // validation for constraint: int
        if (!is_null($alaProviderId) && !(is_int($alaProviderId) || ctype_digit($alaProviderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alaProviderId, true), gettype($alaProviderId)), __LINE__);
        }
        $this->alaProviderId = $alaProviderId;
        return $this;
    }
    /**
     * Get alaUserLocalId value
     * @return int|null
     */
    public function getAlaUserLocalId()
    {
        return $this->alaUserLocalId;
    }
    /**
     * Set alaUserLocalId value
     * @param int $alaUserLocalId
     * @return \StructType\ResultType
     */
    public function setAlaUserLocalId($alaUserLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($alaUserLocalId) && !(is_int($alaUserLocalId) || ctype_digit($alaUserLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alaUserLocalId, true), gettype($alaUserLocalId)), __LINE__);
        }
        $this->alaUserLocalId = $alaUserLocalId;
        return $this;
    }
    /**
     * Get serviceDomainId value
     * @return int|null
     */
    public function getServiceDomainId()
    {
        return $this->serviceDomainId;
    }
    /**
     * Set serviceDomainId value
     * @param int $serviceDomainId
     * @return \StructType\ResultType
     */
    public function setServiceDomainId($serviceDomainId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceDomainId) && !(is_int($serviceDomainId) || ctype_digit($serviceDomainId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceDomainId, true), gettype($serviceDomainId)), __LINE__);
        }
        $this->serviceDomainId = $serviceDomainId;
        return $this;
    }
    /**
     * Get businessDomain value
     * @return string|null
     */
    public function getBusinessDomain()
    {
        return $this->businessDomain;
    }
    /**
     * Set businessDomain value
     * @uses \EnumType\BusinessDomain::valueIsValid()
     * @uses \EnumType\BusinessDomain::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessDomain
     * @return \StructType\ResultType
     */
    public function setBusinessDomain($businessDomain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessDomain::valueIsValid($businessDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessDomain', is_array($businessDomain) ? implode(', ', $businessDomain) : var_export($businessDomain, true), implode(', ', \EnumType\BusinessDomain::getValidValues())), __LINE__);
        }
        $this->businessDomain = $businessDomain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
