<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultBasicType StructType
 * Meta information extracted from the WSDL
 * - documentation: Basic result type composed of a success flag and a message. See document ALEX_Messages_Vxyz.xlsx for the detailed list.
 * @subpackage Structs
 */
class ResultBasicType extends AbstractStructBase
{
    /**
     * The success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $success;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\MessageType
     */
    public $message;
    /**
     * Constructor method for ResultBasicType
     * @uses ResultBasicType::setSuccess()
     * @uses ResultBasicType::setMessage()
     * @param bool $success
     * @param \StructType\MessageType $message
     */
    public function __construct($success = null, \StructType\MessageType $message = null)
    {
        $this
            ->setSuccess($success)
            ->setMessage($message);
    }
    /**
     * Get success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param bool $success
     * @return \StructType\ResultBasicType
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
    /**
     * Get message value
     * @return \StructType\MessageType|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param \StructType\MessageType $message
     * @return \StructType\ResultBasicType
     */
    public function setMessage(\StructType\MessageType $message = null)
    {
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultBasicType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
