<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for restartCpeRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "restartCpeRequest".
 * @subpackage Structs
 */
class RestartCpeRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The fiberConnection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\FiberConnectionRequestType
     */
    public $fiberConnection;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * Constructor method for restartCpeRequestAlau
     * @uses RestartCpeRequestAlau::setAuthentication()
     * @uses RestartCpeRequestAlau::setFiberConnection()
     * @uses RestartCpeRequestAlau::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\FiberConnectionRequestType $fiberConnection
     * @param \StructType\AlexBusinessFocusType $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\FiberConnectionRequestType $fiberConnection = null, \StructType\AlexBusinessFocusType $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setFiberConnection($fiberConnection)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\RestartCpeRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get fiberConnection value
     * @return \StructType\FiberConnectionRequestType
     */
    public function getFiberConnection()
    {
        return $this->fiberConnection;
    }
    /**
     * Set fiberConnection value
     * @param \StructType\FiberConnectionRequestType $fiberConnection
     * @return \StructType\RestartCpeRequestAlau
     */
    public function setFiberConnection(\StructType\FiberConnectionRequestType $fiberConnection = null)
    {
        $this->fiberConnection = $fiberConnection;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\RestartCpeRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestartCpeRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
