<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relocateSubscriptionRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "relocateSubscription".
 * @subpackage Structs
 */
class RelocateSubscriptionRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\SubscriptionType
     */
    public $subscription;
    /**
     * The oldSubscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $oldSubscriptionEndPointId;
    /**
     * The newSubscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $newSubscriptionEndPointId;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reason;
    /**
     * Constructor method for relocateSubscriptionRequestAlau
     * @uses RelocateSubscriptionRequestAlau::setAuthentication()
     * @uses RelocateSubscriptionRequestAlau::setSubscription()
     * @uses RelocateSubscriptionRequestAlau::setOldSubscriptionEndPointId()
     * @uses RelocateSubscriptionRequestAlau::setNewSubscriptionEndPointId()
     * @uses RelocateSubscriptionRequestAlau::setFocus()
     * @uses RelocateSubscriptionRequestAlau::setReason()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\SubscriptionType $subscription
     * @param string $oldSubscriptionEndPointId
     * @param string $newSubscriptionEndPointId
     * @param \StructType\AlexBusinessFocusType $focus
     * @param string $reason
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\SubscriptionType $subscription = null, $oldSubscriptionEndPointId = null, $newSubscriptionEndPointId = null, \StructType\AlexBusinessFocusType $focus = null, $reason = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setSubscription($subscription)
            ->setOldSubscriptionEndPointId($oldSubscriptionEndPointId)
            ->setNewSubscriptionEndPointId($newSubscriptionEndPointId)
            ->setFocus($focus)
            ->setReason($reason);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\SubscriptionType
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\SubscriptionType $subscription
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public function setSubscription(\StructType\SubscriptionType $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get oldSubscriptionEndPointId value
     * @return string
     */
    public function getOldSubscriptionEndPointId()
    {
        return $this->oldSubscriptionEndPointId;
    }
    /**
     * Set oldSubscriptionEndPointId value
     * @param string $oldSubscriptionEndPointId
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public function setOldSubscriptionEndPointId($oldSubscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($oldSubscriptionEndPointId) && !is_string($oldSubscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldSubscriptionEndPointId, true), gettype($oldSubscriptionEndPointId)), __LINE__);
        }
        $this->oldSubscriptionEndPointId = $oldSubscriptionEndPointId;
        return $this;
    }
    /**
     * Get newSubscriptionEndPointId value
     * @return string
     */
    public function getNewSubscriptionEndPointId()
    {
        return $this->newSubscriptionEndPointId;
    }
    /**
     * Set newSubscriptionEndPointId value
     * @param string $newSubscriptionEndPointId
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public function setNewSubscriptionEndPointId($newSubscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($newSubscriptionEndPointId) && !is_string($newSubscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSubscriptionEndPointId, true), gettype($newSubscriptionEndPointId)), __LINE__);
        }
        $this->newSubscriptionEndPointId = $newSubscriptionEndPointId;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelocateSubscriptionRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
