<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HealthCheckResultType StructType
 * Meta information extracted from the WSDL
 * - documentation: Represents the result from the method call "healthCheckRequest".
 * @subpackage Structs
 */
class HealthCheckResultType extends AbstractStructBase
{
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionType[]
     */
    public $subscription;
    /**
     * The subscriptionEndPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionEndPointType
     */
    public $subscriptionEndPoint;
    /**
     * The cpeInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\CpeInformationType
     */
    public $cpeInformation;
    /**
     * The accessPortInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AccessPortInformationType
     */
    public $accessPortInformation;
    /**
     * Constructor method for HealthCheckResultType
     * @uses HealthCheckResultType::setSubscription()
     * @uses HealthCheckResultType::setSubscriptionEndPoint()
     * @uses HealthCheckResultType::setCpeInformation()
     * @uses HealthCheckResultType::setAccessPortInformation()
     * @param \StructType\SubscriptionType[] $subscription
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @param \StructType\CpeInformationType $cpeInformation
     * @param \StructType\AccessPortInformationType $accessPortInformation
     */
    public function __construct(array $subscription = array(), \StructType\SubscriptionEndPointType $subscriptionEndPoint = null, \StructType\CpeInformationType $cpeInformation = null, \StructType\AccessPortInformationType $accessPortInformation = null)
    {
        $this
            ->setSubscription($subscription)
            ->setSubscriptionEndPoint($subscriptionEndPoint)
            ->setCpeInformation($cpeInformation)
            ->setAccessPortInformation($accessPortInformation);
    }
    /**
     * Get subscription value
     * @return \StructType\SubscriptionType[]|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionForArrayConstraintsFromSetSubscription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $healthCheckResultTypeSubscriptionItem) {
            // validation for constraint: itemType
            if (!$healthCheckResultTypeSubscriptionItem instanceof \StructType\SubscriptionType) {
                $invalidValues[] = is_object($healthCheckResultTypeSubscriptionItem) ? get_class($healthCheckResultTypeSubscriptionItem) : sprintf('%s(%s)', gettype($healthCheckResultTypeSubscriptionItem), var_export($healthCheckResultTypeSubscriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subscription property can only contain items of type \StructType\SubscriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionType[] $subscription
     * @return \StructType\HealthCheckResultType
     */
    public function setSubscription(array $subscription = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionArrayErrorMessage = self::validateSubscriptionForArrayConstraintsFromSetSubscription($subscription))) {
            throw new \InvalidArgumentException($subscriptionArrayErrorMessage, __LINE__);
        }
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Add item to subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionType $item
     * @return \StructType\HealthCheckResultType
     */
    public function addToSubscription(\StructType\SubscriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubscriptionType) {
            throw new \InvalidArgumentException(sprintf('The subscription property can only contain items of type \StructType\SubscriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subscription[] = $item;
        return $this;
    }
    /**
     * Get subscriptionEndPoint value
     * @return \StructType\SubscriptionEndPointType|null
     */
    public function getSubscriptionEndPoint()
    {
        return $this->subscriptionEndPoint;
    }
    /**
     * Set subscriptionEndPoint value
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @return \StructType\HealthCheckResultType
     */
    public function setSubscriptionEndPoint(\StructType\SubscriptionEndPointType $subscriptionEndPoint = null)
    {
        $this->subscriptionEndPoint = $subscriptionEndPoint;
        return $this;
    }
    /**
     * Get cpeInformation value
     * @return \StructType\CpeInformationType|null
     */
    public function getCpeInformation()
    {
        return $this->cpeInformation;
    }
    /**
     * Set cpeInformation value
     * @param \StructType\CpeInformationType $cpeInformation
     * @return \StructType\HealthCheckResultType
     */
    public function setCpeInformation(\StructType\CpeInformationType $cpeInformation = null)
    {
        $this->cpeInformation = $cpeInformation;
        return $this;
    }
    /**
     * Get accessPortInformation value
     * @return \StructType\AccessPortInformationType|null
     */
    public function getAccessPortInformation()
    {
        return $this->accessPortInformation;
    }
    /**
     * Set accessPortInformation value
     * @param \StructType\AccessPortInformationType $accessPortInformation
     * @return \StructType\HealthCheckResultType
     */
    public function setAccessPortInformation(\StructType\AccessPortInformationType $accessPortInformation = null)
    {
        $this->accessPortInformation = $accessPortInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HealthCheckResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
