<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for healthCheckRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "healthCheck".
 * @subpackage Structs
 */
class HealthCheckRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The subscriptionId
     * Meta information extracted from the WSDL
     * - choice: subscriptionId | fiberConnection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subscriptionId;
    /**
     * The fiberConnection
     * Meta information extracted from the WSDL
     * - choice: subscriptionId | fiberConnection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\FiberConnectionRequestType
     */
    public $fiberConnection;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * Constructor method for healthCheckRequestAlau
     * @uses HealthCheckRequestAlau::setAuthentication()
     * @uses HealthCheckRequestAlau::setSubscriptionId()
     * @uses HealthCheckRequestAlau::setFiberConnection()
     * @uses HealthCheckRequestAlau::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param string $subscriptionId
     * @param \StructType\FiberConnectionRequestType $fiberConnection
     * @param \StructType\AlexBusinessFocusType $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, $subscriptionId = null, \StructType\FiberConnectionRequestType $fiberConnection = null, \StructType\AlexBusinessFocusType $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setSubscriptionId($subscriptionId)
            ->setFiberConnection($fiberConnection)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\HealthCheckRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get subscriptionId value
     * @return string
     */
    public function getSubscriptionId()
    {
        return isset($this->subscriptionId) ? $this->subscriptionId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSubscriptionId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriptionId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSubscriptionIdForChoiceConstraintsFromSetSubscriptionId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'fiberConnection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property subscriptionId can\'t be set as the property %s is already set. Only one property must be set among these properties: subscriptionId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set subscriptionId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $subscriptionId
     * @return \StructType\HealthCheckRequestAlau
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: choice(subscriptionId, fiberConnection)
        if ('' !== ($subscriptionIdChoiceErrorMessage = self::validateSubscriptionIdForChoiceConstraintsFromSetSubscriptionId($subscriptionId))) {
            throw new \InvalidArgumentException($subscriptionIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->subscriptionId);
        } else {
            $this->subscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get fiberConnection value
     * @return \StructType\FiberConnectionRequestType
     */
    public function getFiberConnection()
    {
        return isset($this->fiberConnection) ? $this->fiberConnection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFiberConnection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFiberConnection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFiberConnectionForChoiceConstraintsFromSetFiberConnection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'subscriptionId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property fiberConnection can\'t be set as the property %s is already set. Only one property must be set among these properties: fiberConnection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set fiberConnection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FiberConnectionRequestType $fiberConnection
     * @return \StructType\HealthCheckRequestAlau
     */
    public function setFiberConnection(\StructType\FiberConnectionRequestType $fiberConnection = null)
    {
        // validation for constraint: choice(subscriptionId, fiberConnection)
        if ('' !== ($fiberConnectionChoiceErrorMessage = self::validateFiberConnectionForChoiceConstraintsFromSetFiberConnection($fiberConnection))) {
            throw new \InvalidArgumentException($fiberConnectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($fiberConnection) || (is_array($fiberConnection) && empty($fiberConnection))) {
            unset($this->fiberConnection);
        } else {
            $this->fiberConnection = $fiberConnection;
        }
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\HealthCheckRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HealthCheckRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
