<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSubscriptionInformationResponseAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U response description for the method "getSubscriptionInformation".
 * @subpackage Structs
 */
class GetSubscriptionInformationResponseAlau extends ResultType
{
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionType[]
     */
    public $subscription;
    /**
     * Constructor method for getSubscriptionInformationResponseAlau
     * @uses GetSubscriptionInformationResponseAlau::setSubscription()
     * @param \StructType\SubscriptionType[] $subscription
     */
    public function __construct(array $subscription = array())
    {
        $this
            ->setSubscription($subscription);
    }
    /**
     * Get subscription value
     * @return \StructType\SubscriptionType[]|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionForArrayConstraintsFromSetSubscription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getSubscriptionInformationResponseAlauSubscriptionItem) {
            // validation for constraint: itemType
            if (!$getSubscriptionInformationResponseAlauSubscriptionItem instanceof \StructType\SubscriptionType) {
                $invalidValues[] = is_object($getSubscriptionInformationResponseAlauSubscriptionItem) ? get_class($getSubscriptionInformationResponseAlauSubscriptionItem) : sprintf('%s(%s)', gettype($getSubscriptionInformationResponseAlauSubscriptionItem), var_export($getSubscriptionInformationResponseAlauSubscriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subscription property can only contain items of type \StructType\SubscriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionType[] $subscription
     * @return \StructType\GetSubscriptionInformationResponseAlau
     */
    public function setSubscription(array $subscription = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionArrayErrorMessage = self::validateSubscriptionForArrayConstraintsFromSetSubscription($subscription))) {
            throw new \InvalidArgumentException($subscriptionArrayErrorMessage, __LINE__);
        }
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Add item to subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionType $item
     * @return \StructType\GetSubscriptionInformationResponseAlau
     */
    public function addToSubscription(\StructType\SubscriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubscriptionType) {
            throw new \InvalidArgumentException(sprintf('The subscription property can only contain items of type \StructType\SubscriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subscription[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubscriptionInformationResponseAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
